/*
 * Decompiled with CFR 0.152.
 */
package doctor4t.defile.render.test;

import doctor4t.defile.render.test.RenderHelper;
import doctor4t.defile.render.test.TrailPoint;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_243;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

@Environment(value=EnvType.CLIENT)
public class VFXBuilders {
    public static WorldVFXBuilder createWorld() {
        return new WorldVFXBuilder();
    }

    @Environment(value=EnvType.CLIENT)
    public static class WorldVFXBuilder {
        protected float r = 1.0f;
        protected float g = 1.0f;
        protected float b = 1.0f;
        protected float a = 1.0f;
        protected float xOffset = 0.0f;
        protected float yOffset = 0.0f;
        protected float zOffset = 0.0f;
        protected int light = 0xF000F0;
        protected float u0 = 0.0f;
        protected float v0 = 0.0f;
        protected float u1 = 1.0f;
        protected float v1 = 1.0f;
        class_293 format;
        WorldVertexPlacementSupplier supplier;

        public WorldVFXBuilder setPosColorDefaultFormat() {
            return this.setVertexSupplier((c, l, x, y, z, u, v) -> {
                if (l == null) {
                    c.method_22912((double)x, (double)y, (double)z).method_22915(this.r, this.g, this.b, this.a).method_1344();
                } else {
                    c.method_22918(l, x, y, z).method_22915(this.r, this.g, this.b, this.a).method_1344();
                }
            }).setFormat(class_290.field_1576);
        }

        public WorldVFXBuilder setPosColorLightmapDefaultFormat() {
            return this.setVertexSupplier((c, l, x, y, z, u, v) -> {
                if (l == null) {
                    c.method_22912((double)x, (double)y, (double)z).method_22915(this.r, this.g, this.b, this.a).method_22916(this.light).method_1344();
                } else {
                    c.method_22918(l, x, y, z).method_22915(this.r, this.g, this.b, this.a).method_22916(this.light).method_1344();
                }
            }).setFormat(class_290.field_21468);
        }

        public WorldVFXBuilder setPosTexDefaultFormat() {
            return this.setVertexSupplier((c, l, x, y, z, u, v) -> {
                if (l == null) {
                    c.method_22912((double)x, (double)y, (double)z).method_22913(u, v).method_1344();
                } else {
                    c.method_22918(l, x, y, z).method_22913(u, v).method_1344();
                }
            }).setFormat(class_290.field_1585);
        }

        public WorldVFXBuilder setPosColorTexDefaultFormat() {
            return this.setVertexSupplier((c, l, x, y, z, u, v) -> {
                if (l == null) {
                    c.method_22912((double)x, (double)y, (double)z).method_22915(this.r, this.g, this.b, this.a).method_22913(u, v).method_1344();
                } else {
                    c.method_22918(l, x, y, z).method_22915(this.r, this.g, this.b, this.a).method_22913(u, v).method_1344();
                }
            }).setFormat(class_290.field_20887);
        }

        public WorldVFXBuilder setPosColorTexLightmapDefaultFormat() {
            return this.setVertexSupplier((c, l, x, y, z, u, v) -> {
                if (l == null) {
                    c.method_22912((double)x, (double)y, (double)z).method_22915(this.r, this.g, this.b, this.a).method_22913(u, v).method_22916(this.light).method_1344();
                } else {
                    c.method_22918(l, x, y, z).method_22915(this.r, this.g, this.b, this.a).method_22913(u, v).method_22916(this.light).method_1344();
                }
            }).setFormat(class_290.field_20888);
        }

        public WorldVFXBuilder setFormat(class_293 format) {
            this.format = format;
            return this;
        }

        public WorldVFXBuilder setVertexSupplier(WorldVertexPlacementSupplier supplier) {
            this.supplier = supplier;
            return this;
        }

        public WorldVFXBuilder setColorWithAlpha(Color color) {
            return this.setColor(color.getRed(), color.getGreen(), color.getBlue(), (float)color.getAlpha() / 255.0f);
        }

        public WorldVFXBuilder setColor(Color color) {
            return this.setColor(color.getRed(), color.getGreen(), color.getBlue());
        }

        public WorldVFXBuilder setColor(Color color, float a) {
            return this.setColor(color).setAlpha(a);
        }

        public WorldVFXBuilder setColor(float r, float g, float b, float a) {
            return this.setColor(r, g, b).setAlpha(a);
        }

        public WorldVFXBuilder setColor(float r, float g, float b) {
            this.r = r / 255.0f;
            this.g = g / 255.0f;
            this.b = b / 255.0f;
            return this;
        }

        public WorldVFXBuilder setAlpha(float a) {
            this.a = a;
            return this;
        }

        public WorldVFXBuilder setOffset(float xOffset, float yOffset, float zOffset) {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.zOffset = zOffset;
            return this;
        }

        public WorldVFXBuilder setLight(int light) {
            this.light = light;
            return this;
        }

        public WorldVFXBuilder setUV(float u0, float v0, float u1, float v1) {
            this.u0 = u0;
            this.v0 = v0;
            this.u1 = u1;
            this.v1 = v1;
            return this;
        }

        public WorldVFXBuilder renderTrail(class_4588 vertexConsumer, class_4587 stack, List<class_1162> trailSegments, Function<Float, Float> widthFunc) {
            return this.renderTrail(vertexConsumer, stack, trailSegments, widthFunc, (Float f) -> {});
        }

        public WorldVFXBuilder renderTrail(class_4588 vertexConsumer, class_4587 stack, List<class_1162> trailSegments, Function<Float, Float> widthFunc, Consumer<Float> vfxOperator) {
            return this.renderTrail(vertexConsumer, stack.method_23760().method_23761(), trailSegments, widthFunc, vfxOperator);
        }

        public WorldVFXBuilder renderTrail(class_4588 vertexConsumer, class_1159 pose, List<class_1162> trailSegments, Function<Float, Float> widthFunc, Consumer<Float> vfxOperator) {
            if (trailSegments.size() < 3) {
                return this;
            }
            trailSegments = trailSegments.stream().map(v -> new class_1162(v.method_4953(), v.method_4956(), v.method_4957(), v.method_23853())).collect(Collectors.toList());
            for (class_1162 class_11622 : trailSegments) {
                class_11622.method_35929(this.xOffset, this.yOffset, this.zOffset, 0.0f);
                class_11622.method_22674(pose);
            }
            int count = trailSegments.size() - 1;
            float f = 1.0f / (float)(count - 1);
            ArrayList<TrailPoint> points = new ArrayList<TrailPoint>();
            for (int i = 0; i < count; ++i) {
                float width = widthFunc.apply(Float.valueOf(f * (float)i)).floatValue();
                class_1162 start = (class_1162)trailSegments.get(i);
                class_1162 end = (class_1162)trailSegments.get(i + 1);
                points.add(new TrailPoint(RenderHelper.midpoint(start, end), RenderHelper.screenSpaceQuadOffsets(start, end, width)));
            }
            return this.renderPoints(vertexConsumer, points, this.u0, this.v0, this.u1, this.v1, vfxOperator);
        }

        public WorldVFXBuilder renderPoints(class_4588 vertexConsumer, List<TrailPoint> trailPoints, float u0, float v0, float u1, float v1, Consumer<Float> vfxOperator) {
            int count = trailPoints.size() - 1;
            float increment = 1.0f / (float)count;
            vfxOperator.accept(Float.valueOf(0.0f));
            trailPoints.get(0).renderStart(vertexConsumer, this.supplier, u0, v0, u1, class_3532.method_16439((float)increment, (float)v0, (float)v1));
            for (int i = 1; i < count; ++i) {
                float current = class_3532.method_16439((float)((float)i * increment), (float)v0, (float)v1);
                vfxOperator.accept(Float.valueOf(current));
                trailPoints.get(i).renderMid(vertexConsumer, this.supplier, u0, current, u1, current);
            }
            vfxOperator.accept(Float.valueOf(1.0f));
            trailPoints.get(count).renderEnd(vertexConsumer, this.supplier, u0, class_3532.method_16439((float)((float)count * increment), (float)v0, (float)v1), u1, v1);
            return this;
        }

        public WorldVFXBuilder renderBeam(class_4588 vertexConsumer, class_4587 stack, class_243 start, class_243 end, float width) {
            class_310 minecraft = class_310.method_1551();
            start.method_1031((double)this.xOffset, (double)this.yOffset, (double)this.zOffset);
            end.method_1031((double)this.xOffset, (double)this.yOffset, (double)this.zOffset);
            stack.method_22904(-start.field_1352, -start.field_1351, -start.field_1350);
            class_243 cameraPosition = minecraft.method_31975().field_4344.method_19326();
            class_243 delta = end.method_1020(start);
            class_243 normal = start.method_1020(cameraPosition).method_1036(delta).method_1029().method_18805((double)(width / 2.0f), (double)(width / 2.0f), (double)(width / 2.0f));
            class_1159 last = stack.method_23760().method_23761();
            class_243[] positions = new class_243[]{start.method_1020(normal), start.method_1019(normal), end.method_1019(normal), end.method_1020(normal)};
            this.supplier.placeVertex(vertexConsumer, last, (float)positions[0].field_1352, (float)positions[0].field_1351, (float)positions[0].field_1350, this.u0, this.v1);
            this.supplier.placeVertex(vertexConsumer, last, (float)positions[1].field_1352, (float)positions[1].field_1351, (float)positions[1].field_1350, this.u1, this.v1);
            this.supplier.placeVertex(vertexConsumer, last, (float)positions[2].field_1352, (float)positions[2].field_1351, (float)positions[2].field_1350, this.u1, this.v0);
            this.supplier.placeVertex(vertexConsumer, last, (float)positions[3].field_1352, (float)positions[3].field_1351, (float)positions[3].field_1350, this.u0, this.v0);
            stack.method_22904(start.field_1352, start.field_1351, start.field_1350);
            return this;
        }

        public WorldVFXBuilder renderQuad(class_4588 vertexConsumer, class_4587 stack, float size) {
            return this.renderQuad(vertexConsumer, stack, size, size);
        }

        public WorldVFXBuilder renderQuad(class_4588 vertexConsumer, class_4587 stack, float width, float height) {
            class_1160[] positions = new class_1160[]{new class_1160(-1.0f, -1.0f, 0.0f), new class_1160(1.0f, -1.0f, 0.0f), new class_1160(1.0f, 1.0f, 0.0f), new class_1160(-1.0f, 1.0f, 0.0f)};
            return this.renderQuad(vertexConsumer, stack, positions, width, height);
        }

        public WorldVFXBuilder renderQuad(class_4588 vertexConsumer, class_4587 stack, class_1160[] positions, float size) {
            return this.renderQuad(vertexConsumer, stack, positions, size, size);
        }

        public WorldVFXBuilder renderQuad(class_4588 vertexConsumer, class_4587 stack, class_1160[] positions, float width, float height) {
            class_1159 last = stack.method_23760().method_23761();
            stack.method_22904((double)this.xOffset, (double)this.yOffset, (double)this.zOffset);
            for (class_1160 position : positions) {
                position.method_23849(width, height, width);
            }
            this.supplier.placeVertex(vertexConsumer, last, positions[0].method_4943(), positions[0].method_4945(), positions[0].method_4947(), this.u0, this.v1);
            this.supplier.placeVertex(vertexConsumer, last, positions[1].method_4943(), positions[1].method_4945(), positions[1].method_4947(), this.u1, this.v1);
            this.supplier.placeVertex(vertexConsumer, last, positions[2].method_4943(), positions[2].method_4945(), positions[2].method_4947(), this.u1, this.v0);
            this.supplier.placeVertex(vertexConsumer, last, positions[3].method_4943(), positions[3].method_4945(), positions[3].method_4947(), this.u0, this.v0);
            stack.method_22904((double)(-this.xOffset), (double)(-this.yOffset), (double)(-this.zOffset));
            return this;
        }

        public WorldVFXBuilder renderScreenSpaceQuad(class_4588 vertexConsumer, class_4587 stack, float size) {
            return this.renderScreenSpaceQuad(vertexConsumer, stack, size, size);
        }

        public WorldVFXBuilder renderScreenSpaceQuad(class_4588 vertexConsumer, class_4587 stack, float width, float height) {
            class_1160[] positions = new class_1160[]{new class_1160(-1.0f, -1.0f, 0.0f), new class_1160(1.0f, -1.0f, 0.0f), new class_1160(1.0f, 1.0f, 0.0f), new class_1160(-1.0f, 1.0f, 0.0f)};
            return this.renderScreenSpaceQuad(vertexConsumer, stack, positions, width, height);
        }

        public WorldVFXBuilder renderScreenSpaceQuad(class_4588 vertexConsumer, class_4587 stack, class_1160[] positions, float size) {
            return this.renderScreenSpaceQuad(vertexConsumer, stack, positions, size, size);
        }

        public WorldVFXBuilder renderScreenSpaceQuad(class_4588 vertexConsumer, class_4587 stack, class_1160[] positions, float width, float height) {
            class_1159 last = stack.method_23760().method_23761();
            stack.method_22904((double)this.xOffset, (double)this.yOffset, (double)this.zOffset);
            for (class_1160 position : positions) {
                position.method_23849(width, height, width);
                position.method_23215(stack.method_23760().method_23762());
            }
            this.supplier.placeVertex(vertexConsumer, last, positions[0].method_4943(), positions[0].method_4945(), positions[0].method_4947(), this.u0, this.v1);
            this.supplier.placeVertex(vertexConsumer, last, positions[1].method_4943(), positions[1].method_4945(), positions[1].method_4947(), this.u1, this.v1);
            this.supplier.placeVertex(vertexConsumer, last, positions[2].method_4943(), positions[2].method_4945(), positions[2].method_4947(), this.u1, this.v0);
            this.supplier.placeVertex(vertexConsumer, last, positions[3].method_4943(), positions[3].method_4945(), positions[3].method_4947(), this.u0, this.v0);
            stack.method_22904((double)(-this.xOffset), (double)(-this.yOffset), (double)(-this.zOffset));
            return this;
        }

        public WorldVFXBuilder renderSphere(class_4588 vertexConsumer, class_4587 stack, float radius, int longs, int lats) {
            class_1159 last = stack.method_23760().method_23761();
            stack.method_22904((double)this.xOffset, (double)this.yOffset, (double)this.zOffset);
            float startU = 0.0f;
            float startV = 0.0f;
            float endU = (float)Math.PI * 2;
            float endV = (float)Math.PI;
            float stepU = (endU - startU) / (float)longs;
            float stepV = (endV - startV) / (float)lats;
            for (int i = 0; i < longs; ++i) {
                for (int j = 0; j < lats; ++j) {
                    float u = (float)i * stepU + startU;
                    float v = (float)j * stepV + startV;
                    float un = i + 1 == longs ? endU : (float)(i + 1) * stepU + startU;
                    float vn = j + 1 == lats ? endV : (float)(j + 1) * stepV + startV;
                    class_1160 p0 = RenderHelper.parametricSphere(u, v, radius);
                    class_1160 p1 = RenderHelper.parametricSphere(u, vn, radius);
                    class_1160 p2 = RenderHelper.parametricSphere(un, v, radius);
                    class_1160 p3 = RenderHelper.parametricSphere(un, vn, radius);
                    float textureU = u / endU * radius;
                    float textureV = v / endV * radius;
                    float textureUN = un / endU * radius;
                    float textureVN = vn / endV * radius;
                    RenderHelper.vertexPosColorUVLight(vertexConsumer, last, p0.method_4943(), p0.method_4945(), p0.method_4947(), this.r, this.g, this.b, this.a, textureU, textureV, this.light);
                    RenderHelper.vertexPosColorUVLight(vertexConsumer, last, p2.method_4943(), p2.method_4945(), p2.method_4947(), this.r, this.g, this.b, this.a, textureUN, textureV, this.light);
                    RenderHelper.vertexPosColorUVLight(vertexConsumer, last, p1.method_4943(), p1.method_4945(), p1.method_4947(), this.r, this.g, this.b, this.a, textureU, textureVN, this.light);
                    RenderHelper.vertexPosColorUVLight(vertexConsumer, last, p3.method_4943(), p3.method_4945(), p3.method_4947(), this.r, this.g, this.b, this.a, textureUN, textureVN, this.light);
                    RenderHelper.vertexPosColorUVLight(vertexConsumer, last, p1.method_4943(), p1.method_4945(), p1.method_4947(), this.r, this.g, this.b, this.a, textureU, textureVN, this.light);
                    RenderHelper.vertexPosColorUVLight(vertexConsumer, last, p2.method_4943(), p2.method_4945(), p2.method_4947(), this.r, this.g, this.b, this.a, textureUN, textureV, this.light);
                }
            }
            stack.method_22904((double)(-this.xOffset), (double)(-this.yOffset), (double)(-this.zOffset));
            return this;
        }

        @Environment(value=EnvType.CLIENT)
        public static interface WorldVertexPlacementSupplier {
            public void placeVertex(class_4588 var1, class_1159 var2, float var3, float var4, float var5, float var6, float var7);
        }
    }
}

