/*
 * Decompiled with CFR 0.152.
 */
package goby56.wakes.config;

import goby56.wakes.config.enums.EffectSpawningRule;
import goby56.wakes.config.enums.Resolution;
import goby56.wakes.render.enums.RenderType;
import goby56.wakes.render.enums.WakeColor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class WakesConfig {
    public static final String DEBUG = "Debug";
    public static Map<String, EffectSpawningRule> effectSpawningRules = new HashMap<String, EffectSpawningRule>(Map.of("boat", EffectSpawningRule.SIMULATION_AND_PLANES, "player", EffectSpawningRule.ONLY_SIMULATION, "other_players", EffectSpawningRule.ONLY_SIMULATION, "mobs", EffectSpawningRule.ONLY_SIMULATION, "items", EffectSpawningRule.ONLY_SIMULATION));
    public static float wavePropagationFactor = 0.8f;
    public static float waveDecayFactor = 0.5f;
    public static int initialStrength = 20;
    public static int paddleStrength = 100;
    public static int splashStrength = 100;
    public static boolean disableMod = false;
    public static int floodFillDistance = 2;
    public static int ticksBeforeFill = 2;
    public static RenderType renderType = RenderType.AUTO;
    public static boolean drawDebugBoxes = false;
    public static boolean showDebugInfo = false;
    public static float shaderLightPassthrough = 1.0f;
    public static int maxNodeAge = 10;
    public static int wakeVisibilityDuration = 28;
    public static Resolution wakeResolution = Resolution.SIXTEEN;
    public static float wakeOpacity = 1.0f;
    public static List<ColorInterval> colorIntervals = List.of(new ColorInterval(WakeColor.TRANSPARENT, -15, 1), new ColorInterval(WakeColor.BLACK, 1, 10), new ColorInterval(WakeColor.FOLLY_RED, 10, 20), new ColorInterval(WakeColor.BLACK, 20, 45), new ColorInterval(WakeColor.GRAY, 45, 50));

    @Environment(value=EnvType.CLIENT)
    public static class ColorInterval {
        public WakeColor color;
        public int lower;
        public int upper;

        public ColorInterval(WakeColor color, int lower, int upper) {
            this.color = color;
            this.lower = lower;
            this.upper = upper;
        }

        public void setColor(WakeColor color) {
            this.color = color;
        }

        public void setLower(int lower) {
            this.lower = lower;
        }

        public void setUpper(int upper) {
            this.upper = upper;
        }
    }
}

