/*
 * Decompiled with CFR 0.152.
 */
package goby56.wakes.debug;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
public class WakesDebugInfo {
    public static double nodeLogicTime = 0.0;
    public static double texturingTime = 0.0;
    public static ArrayList<Long> renderingTime = new ArrayList();
    public static int quadsRendered = 0;
    public static int nodeCount = 0;

    public static void reset() {
        nodeCount = 0;
        nodeLogicTime = 0.0;
        texturingTime = 0.0;
        renderingTime = new ArrayList();
    }

    public static void show(CallbackInfoReturnable<List<String>> info) {
        ((List)info.getReturnValue()).add(String.format("[Wakes] Rendering %d quads for %d wake nodes", quadsRendered, nodeCount));
        ((List)info.getReturnValue()).add(String.format("[Wakes] Node logic: %.2fms/t", 1.0E-5 * nodeLogicTime));
        ((List)info.getReturnValue()).add(String.format("[Wakes] Texturing: %.2fms/t", 1.0E-5 * texturingTime));
        ((List)info.getReturnValue()).add(String.format("[Wakes] Rendering: %.3fms/f", 1.0E-5 * (double)renderingTime.stream().reduce(0L, Long::sum).longValue() / (double)renderingTime.size()));
    }
}

