/*
 * Decompiled with CFR 0.152.
 */
package goby56.wakes.render;

import com.mojang.blaze3d.systems.RenderSystem;
import goby56.wakes.config.WakesConfig;
import goby56.wakes.config.enums.Resolution;
import goby56.wakes.debug.WakesDebugInfo;
import goby56.wakes.render.WakeTexture;
import goby56.wakes.simulation.Brick;
import goby56.wakes.simulation.WakeHandler;
import goby56.wakes.simulation.WakeNode;
import java.util.ArrayList;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1159;

@Environment(value=EnvType.CLIENT)
public class WakeRenderer
implements WorldRenderEvents.AfterTranslucent {
    public static Map<Resolution, WakeTexture> wakeTextures = null;

    private void initTextures() {
        wakeTextures = Map.of(Resolution.EIGHT, new WakeTexture(Resolution.EIGHT.res), Resolution.SIXTEEN, new WakeTexture(Resolution.SIXTEEN.res), Resolution.THIRTYTWO, new WakeTexture(Resolution.THIRTYTWO.res));
    }

    public void afterTranslucent(WorldRenderContext context) {
        WakeHandler wakeHandler;
        if (WakesConfig.disableMod) {
            WakesDebugInfo.quadsRendered = 0;
            return;
        }
        if (wakeTextures == null) {
            this.initTextures();
        }
        if ((wakeHandler = WakeHandler.getInstance()) == null || wakeHandler.resolutionResetScheduled) {
            return;
        }
        ArrayList<Brick> bricks = wakeHandler.getVisible(context.frustum(), Brick.class);
        class_1159 matrix = context.matrixStack().method_23760().method_23761();
        RenderSystem.enableBlend();
        context.lightmapTextureManager().method_3316();
        Resolution resolution = WakesConfig.wakeResolution;
        if (resolution.res != WakeNode.res) {
            return;
        }
        int n = 0;
        long tRendering = System.nanoTime();
        for (Brick brick : bricks) {
            wakeTextures.get((Object)resolution).render(matrix, context.camera(), brick);
            brick.addTimeDelta(context.tickDelta());
            ++n;
        }
        WakesDebugInfo.renderingTime.add(System.nanoTime() - tRendering);
        WakesDebugInfo.quadsRendered = n;
    }
}

