/*
 * Decompiled with CFR 0.152.
 */
package goby56.wakes.simulation;

import goby56.wakes.config.WakesConfig;
import goby56.wakes.config.enums.Resolution;
import goby56.wakes.simulation.QuadTree;
import goby56.wakes.simulation.QueueSet;
import goby56.wakes.simulation.WakeNode;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_4604;

@Environment(value=EnvType.CLIENT)
public class WakeHandler {
    private static WakeHandler INSTANCE;
    private final int minY;
    private final int maxY;
    private final QuadTree[] trees;
    private final QueueSet<WakeNode>[] toBeInserted;
    public class_1937 world;
    public boolean resolutionResetScheduled = false;

    private WakeHandler(class_1937 world) {
        this.world = world;
        WakeNode.calculateWaveDevelopmentFactors();
        this.minY = world.method_31607();
        this.maxY = world.method_31600();
        int worldHeight = this.maxY - this.minY;
        this.trees = new QuadTree[worldHeight];
        this.toBeInserted = new QueueSet[worldHeight];
        for (int i = 0; i < worldHeight; ++i) {
            this.toBeInserted[i] = new QueueSet();
        }
    }

    public static WakeHandler getInstance() {
        if (INSTANCE == null) {
            if (class_310.method_1551().field_1687 == null) {
                return null;
            }
            INSTANCE = new WakeHandler((class_1937)class_310.method_1551().field_1687);
        }
        return INSTANCE;
    }

    public static void init(class_1937 world) {
        INSTANCE = new WakeHandler(world);
    }

    public static void kill() {
        INSTANCE = null;
    }

    public static void scheduleResolutionChange(Resolution newRes) {
        WakesConfig.wakeResolution = newRes;
        WakeHandler wakeHandler = WakeHandler.getInstance();
        if (wakeHandler == null) {
            return;
        }
        wakeHandler.resolutionResetScheduled = true;
    }

    public void tick() {
        for (int i = 0; i < this.maxY - this.minY; ++i) {
            QueueSet<WakeNode> pendingNodes = this.toBeInserted[i];
            if (this.resolutionResetScheduled) {
                if (pendingNodes == null) continue;
                pendingNodes.clear();
                continue;
            }
            QuadTree tree = this.trees[i];
            if (tree == null) continue;
            tree.tick();
            while (pendingNodes.peek() != null) {
                tree.insert((WakeNode)pendingNodes.poll());
            }
        }
        if (this.resolutionResetScheduled) {
            this.changeResolution();
        }
    }

    public void insert(WakeNode node) {
        if (this.resolutionResetScheduled) {
            return;
        }
        int i = this.getArrayIndex(node.y);
        if (i < 0) {
            return;
        }
        if (this.trees[i] == null) {
            this.trees[i] = new QuadTree(node.y);
        }
        if (node.validPos(this.world)) {
            this.toBeInserted[i].add(node);
        }
    }

    public <T> ArrayList<T> getVisible(class_4604 frustum, Class<T> type) {
        ArrayList visibleQuads = new ArrayList();
        for (int i = 0; i < this.maxY - this.minY; ++i) {
            if (this.trees[i] == null) continue;
            this.trees[i].query(frustum, visibleQuads, type);
        }
        return visibleQuads;
    }

    private int getArrayIndex(int y) {
        if (y < this.minY || y > this.maxY) {
            return -1;
        }
        return y - this.minY;
    }

    private int getYLevel(int i) {
        if (i < 0 || i > this.maxY - this.minY) {
            throw new IndexOutOfBoundsException();
        }
        return i + this.minY;
    }

    private void changeResolution() {
        this.reset();
        WakeNode.res = WakesConfig.wakeResolution.res;
        this.resolutionResetScheduled = false;
    }

    private void reset() {
        for (int i = 0; i < this.maxY - this.minY; ++i) {
            QuadTree tree = this.trees[i];
            if (tree != null) {
                tree.prune();
            }
            this.toBeInserted[i].clear();
        }
    }
}

