/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.block;

import dev.xylonity.companions.common.blockentity.FrogBonanzaBlockEntity;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrogBonanzaBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE_LOWER_N = Stream.of(Block.box((double)2.0, (double)4.0, (double)4.0, (double)14.0, (double)17.0, (double)12.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)-0.5, (double)16.0, (double)3.0, (double)16.5, (double)26.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_UPPER_N = Stream.of(Block.box((double)2.0, (double)-12.0, (double)4.0, (double)14.0, (double)1.0, (double)12.0), Block.box((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)-12.0, (double)16.0), Block.box((double)-0.5, (double)0.0, (double)3.0, (double)16.5, (double)10.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_UPPER_E = Stream.of(Block.box((double)4.0, (double)-12.0, (double)2.0, (double)12.0, (double)1.0, (double)14.0), Block.box((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)-12.0, (double)16.0), Block.box((double)3.0, (double)0.0, (double)-0.5, (double)13.0, (double)10.0, (double)16.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_LOWER_E = Stream.of(Block.box((double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)17.0, (double)14.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)3.0, (double)16.0, (double)-0.5, (double)13.0, (double)26.0, (double)16.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;

    public FrogBonanzaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public long getSeed(@NotNull BlockState pState, @NotNull BlockPos pPos) {
        return pState.getValue(HALF) == DoubleBlockHalf.LOWER ? pPos.asLong() : pPos.below().asLong();
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        Direction d = (Direction)pState.getValue((Property)FACING);
        if (d == Direction.NORTH || d == Direction.SOUTH) {
            return pState.getValue(HALF) == DoubleBlockHalf.LOWER ? SHAPE_LOWER_N : SHAPE_UPPER_N;
        }
        return pState.getValue(HALF) == DoubleBlockHalf.LOWER ? SHAPE_LOWER_E : SHAPE_UPPER_E;
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        level.setBlock(pos.above(), (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockPos pos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        if (pos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(pos.above()).canBeReplaced(pContext)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite())).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public boolean canSurvive(@NotNull BlockState pState, @NotNull LevelReader pLevel, @NotNull BlockPos pPos) {
        if (pState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return pPos.getY() < pLevel.getMaxBuildHeight() - 1;
        }
        BlockState belowState = pLevel.getBlockState(pPos.below());
        return belowState.is((Block)this) && belowState.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pPos, @NotNull BlockPos pNeighborPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)pState.getValue(HALF);
        if (pDirection.getAxis() == Direction.Axis.Y) {
            if (half == DoubleBlockHalf.LOWER && pDirection == Direction.UP) {
                return pNeighborState.is((Block)this) && pNeighborState.getValue(HALF) == DoubleBlockHalf.UPPER ? pState : Blocks.AIR.defaultBlockState();
            }
            if (half == DoubleBlockHalf.UPPER && pDirection == Direction.DOWN) {
                return pNeighborState.is((Block)this) && pNeighborState.getValue(HALF) == DoubleBlockHalf.LOWER ? pState : Blocks.AIR.defaultBlockState();
            }
        }
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public BlockState playerWillDestroy(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull Player pPlayer) {
        if (!pLevel.isClientSide) {
            if (pPlayer.isCreative()) {
                FrogBonanzaBlock.preventCreativeTabDestroy(pLevel, pPos, pState, pPlayer);
            } else {
                BlockPos oPos = pState.getValue(HALF) == DoubleBlockHalf.LOWER ? pPos.above() : pPos.below();
                BlockState oState = pLevel.getBlockState(oPos);
                if (oState.is((Block)this)) {
                    pLevel.setBlock(oPos, Blocks.AIR.defaultBlockState(), 35);
                    pLevel.levelEvent(pPlayer, 2001, oPos, Block.getId((BlockState)oState));
                }
                FrogBonanzaBlock.popResource((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)this));
            }
        }
        return super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
    }

    public static void preventCreativeTabDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos lowerPos;
        BlockState lowerState;
        if (pState.getValue(HALF) == DoubleBlockHalf.UPPER && (lowerState = pLevel.getBlockState(lowerPos = pPos.below())).is(pState.getBlock()) && lowerState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            pLevel.setBlock(lowerPos, Blocks.AIR.defaultBlockState(), 35);
            pLevel.levelEvent(pPlayer, 2001, lowerPos, Block.getId((BlockState)lowerState));
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = this.getMultiblockBlockEntity(level, pos, state);
        if (blockEntity instanceof FrogBonanzaBlockEntity) {
            FrogBonanzaBlockEntity bonanza = (FrogBonanzaBlockEntity)blockEntity;
            return bonanza.interact(player, hand);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, LIT, HALF});
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? CompanionsBlockEntities.FROG_BONANZA.get().create(pos, state) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return pState.getValue(HALF) == DoubleBlockHalf.LOWER && pBlockEntityType == CompanionsBlockEntities.FROG_BONANZA.get() ? FrogBonanzaBlockEntity::tick : null;
    }

    @Nullable
    public BlockEntity getMultiblockBlockEntity(Level level, BlockPos pos, BlockState state) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return level.getBlockEntity(pos);
        }
        BlockPos lowerPos = pos.below();
        BlockState lowerState = level.getBlockState(lowerPos);
        if (lowerState.is((Block)this) && lowerState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return level.getBlockEntity(lowerPos);
        }
        return null;
    }
}

