/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.block;

import dev.xylonity.companions.common.block.AbstractTeslaBlock;
import dev.xylonity.companions.common.blockentity.VoltaicPillarBlockEntity;
import dev.xylonity.companions.common.tesla.TeslaConnectionManager;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VoltaicPillarBlock
extends AbstractTeslaBlock {
    private static final VoxelShape SHAPE_BASE = Stream.of(Block.box((double)4.0, (double)6.5, (double)4.0, (double)12.0, (double)9.5, (double)12.0), Block.box((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)16.0, (double)10.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_TOP = Stream.of(Block.box((double)4.0, (double)6.5, (double)4.0, (double)12.0, (double)9.5, (double)12.0), Block.box((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)10.0, (double)10.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public VoltaicPillarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        VoltaicPillarBlockEntity pillarEntity;
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (be instanceof VoltaicPillarBlockEntity && (pillarEntity = (VoltaicPillarBlockEntity)be).isTop()) {
            return SHAPE_TOP;
        }
        return SHAPE_BASE;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return CompanionsBlockEntities.VOLTAIC_PILLAR.get().create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return pBlockEntityType == CompanionsBlockEntities.VOLTAIC_PILLAR.get() ? VoltaicPillarBlockEntity::tick : null;
    }

    public void onPlace(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pOldState, boolean pMovedByPiston) {
        BlockEntity belowBe;
        VoltaicPillarBlockEntity curr;
        BlockEntity blockEntity;
        BlockEntity aboveBe = pLevel.getBlockEntity(pPos.above());
        if (aboveBe instanceof VoltaicPillarBlockEntity) {
            VoltaicPillarBlockEntity above = (VoltaicPillarBlockEntity)aboveBe;
            blockEntity = pLevel.getBlockEntity(pPos);
            if (blockEntity instanceof VoltaicPillarBlockEntity) {
                curr = (VoltaicPillarBlockEntity)blockEntity;
                TeslaConnectionManager.getInstance().addConnection(above.asConnectionNode(), curr.asConnectionNode());
            }
        }
        if ((belowBe = pLevel.getBlockEntity(pPos.below())) instanceof VoltaicPillarBlockEntity) {
            VoltaicPillarBlockEntity below = (VoltaicPillarBlockEntity)belowBe;
            BlockEntity blockEntity2 = pLevel.getBlockEntity(pPos);
            if (blockEntity2 instanceof VoltaicPillarBlockEntity) {
                VoltaicPillarBlockEntity curr2 = (VoltaicPillarBlockEntity)blockEntity2;
                if (!TeslaConnectionManager.getInstance().getIncoming(below.asConnectionNode()).contains(curr2.asConnectionNode())) {
                    TeslaConnectionManager.getInstance().addConnection(curr2.asConnectionNode(), below.asConnectionNode());
                }
            }
        }
        if ((blockEntity = pLevel.getBlockEntity(pPos)) instanceof VoltaicPillarBlockEntity) {
            curr = (VoltaicPillarBlockEntity)blockEntity;
            if (!pLevel.getBlockState(pPos.above()).isAir()) {
                curr.setHasBlockOnTop(true);
            } else {
                curr.setHasBlockOnTop(false);
                curr.setIsTop(true);
            }
        }
        super.onPlace(pState, pLevel, pPos, pOldState, pMovedByPiston);
    }
}

