/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.entity.ShadeEntity;
import dev.xylonity.companions.common.entity.projectile.ShadeAltarUpgradeHaloProjectile;
import dev.xylonity.companions.common.item.ShadowBellItem;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AbstractShadeAltarBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final int MAX_CHARGES = CompanionsConfig.SHADOW_ALTAR_MAX_CHARGES;
    private static final int MAX_BLOOD_CHARGES = CompanionsConfig.SHADOW_ALTAR_BLOOD_CHARGES_AMOUNT;
    public UUID activeShadeUUID = null;
    private int charges = 0;
    private int prevCharges = 0;

    public AbstractShadeAltarBlockEntity(BlockEntityType<?> pType, BlockPos pos, BlockState state) {
        super(pType, pos, state);
    }

    public int getCharges() {
        return this.charges;
    }

    public int getMaxCharges() {
        return MAX_CHARGES;
    }

    public int getBloodCharges() {
        return MAX_BLOOD_CHARGES;
    }

    public boolean isBloodUpgradeActive() {
        return this.getCharges() >= MAX_CHARGES - MAX_BLOOD_CHARGES;
    }

    public boolean addCharge() {
        if (this.charges >= MAX_CHARGES) {
            if (this.level != null) {
                this.level.playSound(null, this.getBlockPos(), CompanionsSounds.SHADE_ALTAR_FULL.get(), SoundSource.BLOCKS);
            }
            return false;
        }
        ++this.charges;
        this.setChanged();
        if (this.level != null) {
            this.level.playSound(null, this.getBlockPos(), CompanionsSounds.SHADE_ALTAR_CHARGE.get(), SoundSource.BLOCKS);
        }
        return true;
    }

    public boolean consumeCharge() {
        if (this.charges <= 0) {
            return false;
        }
        --this.charges;
        this.setChanged();
        return true;
    }

    public void setCharges(int charges) {
        this.charges = charges;
        this.setChanged();
    }

    public void clearCharges() {
        this.charges = 0;
        this.setChanged();
    }

    protected boolean isImportantChargeDiff() {
        return this.prevCharges == 0 && this.charges == 1 || this.prevCharges == MAX_CHARGES - MAX_BLOOD_CHARGES - 1 && this.charges == MAX_CHARGES - MAX_BLOOD_CHARGES;
    }

    protected boolean hasIncreasedFromPrevInteraction() {
        return this.charges > this.prevCharges;
    }

    public void setChanged() {
        ShadeAltarUpgradeHaloProjectile halo;
        super.setChanged();
        if (this.level != null && this.hasIncreasedFromPrevInteraction() && (halo = (ShadeAltarUpgradeHaloProjectile)CompanionsEntities.SHADE_ALTAR_UPGRADE_HALO.get().create(this.level)) != null) {
            halo.setPos((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.015, (double)this.getBlockPos().getZ() + 0.5);
            this.level.addFreshEntity((Entity)halo);
        }
        this.prevCharges = this.charges;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("Charges", this.charges);
        tag.putInt("PrevCharges", this.prevCharges);
        if (this.activeShadeUUID != null) {
            tag.putUUID("ActiveShadeUUID", this.activeShadeUUID);
        } else {
            tag.remove("ActiveShadeUUID");
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.charges = tag.getInt("Charges");
        this.prevCharges = tag.getInt("PrevCharges");
        this.activeShadeUUID = tag.hasUUID("ActiveShadeUUID") ? tag.getUUID("ActiveShadeUUID") : null;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider holders) {
        super.handleUpdateTag(tag, holders);
        this.charges = tag.getInt("Charges");
        this.prevCharges = tag.getInt("PrevCharges");
        this.activeShadeUUID = tag.hasUUID("ActiveShadeUUID") ? tag.getUUID("ActiveShadeUUID") : null;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        tag.putInt("Charges", this.getCharges());
        tag.putInt("PrevCharges", this.prevCharges);
        if (this.activeShadeUUID != null) {
            tag.putUUID("ActiveShadeUUID", this.activeShadeUUID);
        }
        return tag;
    }

    public void sync() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ClientboundBlockEntityDataPacket pkt = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(this.worldPosition), false).forEach(arg_0 -> AbstractShadeAltarBlockEntity.lambda$sync$0((Packet)pkt, arg_0));
    }

    @Nullable
    public abstract ShadeEntity spawnShade(@NotNull Level var1, @NotNull Player var2, @NotNull InteractionHand var3, ShadowBellItem var4);

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public double findPlaceToSpawn(@NotNull Player pPlayer, @NotNull Level pLevel, int blockX, int blockZ) {
        int baseY = Mth.floor((double)pPlayer.getY());
        int minY = pLevel.getMinBuildHeight();
        int maxY = pLevel.getMaxBuildHeight() - 1;
        int spawnY = baseY;
        boolean found = false;
        for (int offset = 0; offset <= Math.max(baseY - minY, maxY - baseY) && !found; ++offset) {
            int yUp;
            int yDown = baseY - offset;
            if (yDown >= minY) {
                BlockPos below = new BlockPos(blockX, yDown - 1, blockZ);
                BlockPos curr = new BlockPos(blockX, yDown, blockZ);
                if (yDown - 1 >= minY && !pLevel.getBlockState(below).isAir() && pLevel.getBlockState(curr).isAir()) {
                    spawnY = yDown;
                    found = true;
                }
            }
            if (found || offset <= 0 || (yUp = baseY + offset) > maxY) continue;
            BlockPos below = new BlockPos(blockX, yUp - 1, blockZ);
            BlockPos curr = new BlockPos(blockX, yUp, blockZ);
            if (yUp - 1 < minY || pLevel.getBlockState(below).isAir() || !pLevel.getBlockState(curr).isAir()) continue;
            spawnY = yUp;
            found = true;
        }
        if (!found) {
            return Math.max(minY + 1, Math.min(maxY, baseY));
        }
        return spawnY;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private static /* synthetic */ void lambda$sync$0(Packet pkt, ServerPlayer p) {
        p.connection.send(pkt);
    }
}

