/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.block.AbstractTeslaBlock;
import dev.xylonity.companions.common.blockentity.AbstractTeslaBlockEntity;
import dev.xylonity.companions.common.tesla.behaviour.lamp.LampPulseBehaviour;
import dev.xylonity.companions.common.util.interfaces.ITeslaNodeBehaviour;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoBlockEntity;

public class PlasmaLampBlockEntity
extends AbstractTeslaBlockEntity
implements GeoBlockEntity {
    private final ITeslaNodeBehaviour pulseBehaviour = new LampPulseBehaviour();
    private int whenToSpawnParticles = new Random().nextInt(100, 360);

    public PlasmaLampBlockEntity(BlockPos pos, BlockState state) {
        super(CompanionsBlockEntities.PLASMA_LAMP.get(), pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (!(t instanceof PlasmaLampBlockEntity)) {
            return;
        }
        PlasmaLampBlockEntity lamp = (PlasmaLampBlockEntity)t;
        lamp.pulseBehaviour.process(lamp, level, blockPos, blockState);
        if (lamp.isActive() && lamp.whenToSpawnParticles == 0 && level.isClientSide) {
            Companions.PROXY.spawnPlasmaLampElectricArc(lamp, level, blockPos);
        }
        if (lamp.whenToSpawnParticles == 0) {
            lamp.whenToSpawnParticles = new Random().nextInt(100, 360);
        }
        --lamp.whenToSpawnParticles;
    }

    @Override
    @NotNull
    public Vec3 electricalChargeOriginOffset() {
        return new Vec3(0.0, 0.0, 0.0);
    }

    @Override
    @NotNull
    public Vec3 electricalChargeEndOffset() {
        Direction dir = (Direction)this.getBlockState().getValue((Property)AbstractTeslaBlock.FACING);
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> new Vec3(0.0, 0.2, 0.0);
            case Direction.UP -> new Vec3(0.0, 0.75, 0.0);
            case Direction.NORTH -> new Vec3(0.0, 0.5, -0.45);
            case Direction.SOUTH -> new Vec3(0.0, 0.5, 0.45);
            case Direction.WEST -> new Vec3(-0.45, 0.5, 0.0);
            case Direction.EAST -> new Vec3(0.45, 0.5, 0.0);
        };
    }
}

