/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity;

import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class ShadeEntity
extends CompanionEntity {
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.defineId(ShadeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> SHOULD_LOOK_AT_TARGET = SynchedEntityData.defineId(ShadeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_SPAWNING = SynchedEntityData.defineId(ShadeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_BLOOD = SynchedEntityData.defineId(ShadeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.defineId(ShadeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> RESKIN = SynchedEntityData.defineId(ShadeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    protected ShadeEntity(EntityType<? extends CompanionEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getLifetime() == 0) {
            this.discard();
        }
    }

    @Override
    public void remove(@NotNull Entity.RemovalReason pReason) {
        super.remove(pReason);
        for (int i = 0; i < 25; ++i) {
            double vx = (this.level().random.nextDouble() - 0.5) * (double)this.getBbWidth();
            double vy = (this.level().random.nextDouble() - 0.5) * (double)this.getBbHeight();
            double vz = (this.level().random.nextDouble() - 0.5) * (double)this.getBbWidth();
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.sendParticles((ParticleOptions)CompanionsParticles.SHADE_TRAIL.get(), this.getX(), this.getY(), this.getZ(), 1, vx, vy, vz, 0.15);
            if (i % 3 != 0) continue;
            level2.sendParticles((ParticleOptions)CompanionsParticles.SHADE_SUMMON.get(), this.getX(), this.getY(), this.getZ(), 1, vx, vy, vz, 0.35);
        }
        this.playSound(CompanionsSounds.SHADE_DESPAWN.get());
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime >= 1 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public int getAttackType() {
        return (Integer)this.entityData.get(ATTACK_TYPE);
    }

    public void setAttackType(int type) {
        this.entityData.set(ATTACK_TYPE, (Object)type);
    }

    public boolean shouldLookAtTarget() {
        return (Boolean)this.entityData.get(SHOULD_LOOK_AT_TARGET);
    }

    public void setShouldLookAtTarget(boolean shouldLookAtTarget) {
        this.entityData.set(SHOULD_LOOK_AT_TARGET, (Object)shouldLookAtTarget);
    }

    public boolean isSpawning() {
        return (Boolean)this.entityData.get(IS_SPAWNING);
    }

    public void setIsSpawning(boolean isSpawning) {
        this.entityData.set(IS_SPAWNING, (Object)isSpawning);
    }

    public boolean hasReskin() {
        return (Boolean)this.entityData.get(RESKIN);
    }

    public void setHasReskin(boolean hasReskin) {
        this.entityData.set(RESKIN, (Object)hasReskin);
    }

    public boolean isBlood() {
        return (Boolean)this.entityData.get(IS_BLOOD);
    }

    public void setIsBlood(boolean isBlood) {
        this.entityData.set(IS_BLOOD, (Object)isBlood);
    }

    public int getLifetime() {
        return (Integer)this.entityData.get(LIFETIME);
    }

    public void setLifetime(int tick) {
        this.entityData.set(LIFETIME, (Object)tick);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("HasSpawned", this.isSpawning());
        pCompound.putBoolean("IsBlood", this.isBlood());
        pCompound.putInt("Lifetime", this.getLifetime());
        pCompound.putBoolean("HasReskin", this.hasReskin());
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("HasSpawned")) {
            this.setIsSpawning(pCompound.getBoolean("HasSpawned"));
        }
        if (pCompound.contains("IsBlood")) {
            this.setIsBlood(pCompound.getBoolean("IsBlood"));
        }
        if (pCompound.contains("Lifetime")) {
            this.setLifetime(pCompound.getInt("Lifetime"));
        }
        if (pCompound.contains("HasReskin")) {
            this.setHasReskin(pCompound.getBoolean("HasReskin"));
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTACK_TYPE, (Object)0);
        builder.define(SHOULD_LOOK_AT_TARGET, (Object)true);
        builder.define(IS_BLOOD, (Object)false);
        builder.define(IS_SPAWNING, (Object)true);
        builder.define(LIFETIME, (Object)this.getMaxLifetime());
        builder.define(RESKIN, (Object)false);
    }

    public abstract int getMaxLifetime();
}

