/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity;

import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animation.AnimatableManager;

public abstract class SummonFrogEntity
extends CompanionSummonEntity {
    private static final EntityDataAccessor<Integer> CYCLE_COUNTER = SynchedEntityData.defineId(SummonFrogEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int MAX_CYCLE_TICKS = 20;

    public SummonFrogEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public int getCycleCount() {
        return (Integer)this.entityData.get(CYCLE_COUNTER);
    }

    public void setCycleCount(int count) {
        this.entityData.set(CYCLE_COUNTER, (Object)count);
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CYCLE_COUNTER, (Object)-1);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.getCycleCount() == 0) {
                this.playSound(this.jumpSound(), 0.5f, 1.0f);
            }
            if (this.getCycleCount() >= 12) {
                this.setDeltaMovement(new Vec3(0.0, 0.0, 0.0));
            }
            if (this.getCycleCount() >= 0) {
                this.setCycleCount(this.getCycleCount() + 1);
            }
            if (this.getCycleCount() >= 20) {
                this.setCycleCount(-1);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    protected abstract SoundEvent jumpSound();
}

