/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.antlion.tamable.goal;

import dev.xylonity.companions.common.entity.ai.antlion.tamable.AbstractAntlionAttackGoal;
import dev.xylonity.companions.common.entity.companion.AntlionEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class AntlionBaseAttackGoal
extends AbstractAntlionAttackGoal {
    public AntlionBaseAttackGoal(AntlionEntity antlion, int minCd, int maxCd) {
        super(antlion, 15, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.antlion.setNoMovement(true);
    }

    @Override
    public void stop() {
        super.stop();
        this.antlion.setNoMovement(false);
    }

    @Override
    public boolean canUse() {
        LivingEntity target = this.antlion.getTarget();
        if (target != null && this.antlion.distanceToSqr((Entity)target) > 9.0) {
            return false;
        }
        if (this.antlion.getVariant() == 0 && this.antlion.getState() == 0 && target != null) {
            this.antlion.cycleState();
            return false;
        }
        if (!this.antlion.isUnderground()) {
            return false;
        }
        return super.canUse();
    }

    @Override
    protected void performAttack(LivingEntity target) {
        this.antlion.doHurtTarget((Entity)target);
    }

    @Override
    protected int attackDelay() {
        return 7;
    }

    @Override
    protected int attackType() {
        return 1;
    }

    @Override
    protected int variant() {
        return 0;
    }
}

