/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.cloak.goal;

import dev.xylonity.companions.common.entity.ai.cloak.AbstractCloakAttackGoal;
import dev.xylonity.companions.common.entity.companion.CloakEntity;
import dev.xylonity.companions.common.entity.projectile.HolinessStartProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class CloakRedStarAttackGoal
extends AbstractCloakAttackGoal {
    public CloakRedStarAttackGoal(CloakEntity cloak, int minCd, int maxCd) {
        super(cloak, 20, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.cloak.setNoMovement(true);
    }

    @Override
    public void stop() {
        super.stop();
        this.cloak.setNoMovement(false);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.cloak.getTarget() != null) {
            Vec3 dir = this.cloak.getTarget().getEyePosition().subtract(this.cloak.getEyePosition()).normalize();
            float yaw = (float)(Math.atan2(-dir.x, dir.z) * 180.0 / Math.PI);
            float pitch = (float)(Math.asin(-dir.y) * 180.0 / Math.PI);
            this.cloak.setYRot(yaw);
            this.cloak.setXRot(pitch);
            this.cloak.yRotO = yaw;
            this.cloak.xRotO = pitch;
        }
        if (this.cloak.getTarget() != null) {
            LivingEntity e = this.cloak.getTarget();
            this.cloak.getLookControl().setLookAt(e.getX(), e.getY() + (double)(e.getBbHeight() * 0.5f), e.getZ(), 6.0f, 90.0f);
            this.cloak.lookAt((Entity)e, 30.0f, 30.0f);
        }
    }

    @Override
    protected void performAttack(LivingEntity target) {
        Vec3 targetPos = target.position().add(0.0, (double)target.getEyeHeight(), 0.0);
        Vec3 spawnPos = this.cloak.position().add(0.0, (double)this.cloak.getBbHeight() * 0.5, 0.0);
        Vec3 vel = targetPos.subtract(spawnPos).normalize().normalize().scale((double)HolinessStartProjectile.SPEED);
        HolinessStartProjectile star = (HolinessStartProjectile)CompanionsEntities.HOLINESS_STAR.get().create(this.cloak.level());
        if (star != null) {
            star.setOwner((Entity)this.cloak);
            star.setTarget(target);
            star.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
            star.setDeltaMovement(vel);
            star.setNoGravity(true);
            star.setRed(true);
            this.cloak.level().addFreshEntity((Entity)star);
        }
    }

    @Override
    protected int attackDelay() {
        return 12;
    }

    @Override
    protected int attackType() {
        return 2;
    }
}

