/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.cornelius.goal;

import dev.xylonity.companions.common.entity.companion.CorneliusEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;

public class CorneliusMoveToBeeGoal
extends Goal {
    private final CorneliusEntity cornelius;
    private Bee bee;
    private final double speed;

    public CorneliusMoveToBeeGoal(CorneliusEntity cornelius, double speed) {
        this.cornelius = cornelius;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.cornelius.isTame()) {
            return false;
        }
        if (this.cornelius.level().getEntitiesOfClass(Player.class, this.cornelius.getBoundingBox().inflate(10.0)).isEmpty()) {
            return false;
        }
        List bees = this.cornelius.level().getEntitiesOfClass(Bee.class, this.cornelius.getBoundingBox().inflate(10.0), EntitySelector.NO_SPECTATORS);
        if (bees.isEmpty()) {
            return false;
        }
        this.bee = (Bee)bees.get(0);
        return this.bee.isAlive();
    }

    public boolean canContinueToUse() {
        if (this.cornelius.level().getEntitiesOfClass(Player.class, this.cornelius.getBoundingBox().inflate(10.0)).isEmpty()) {
            return false;
        }
        return this.bee != null && this.bee.isAlive() && !this.cornelius.isVehicle();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.bee == null || !this.bee.isAlive()) {
            return;
        }
        this.cornelius.setTarget((LivingEntity)this.bee);
        this.cornelius.getLookControl().setLookAt((Entity)this.bee, 30.0f, 30.0f);
        if (this.cornelius.getCycleCount() == -1) {
            this.cornelius.setCycleCount(this.cornelius.getCycleCount() + 1);
        }
        this.cornelius.getNavigation().moveTo((Entity)this.bee, this.speed);
    }

    public void stop() {
        this.bee = null;
        this.cornelius.getNavigation().stop();
        super.stop();
    }
}

