/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.cornelius.summon.goal;

import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import dev.xylonity.companions.common.entity.ai.cornelius.summon.AbstractCorneliusSummonAttackGoal;
import dev.xylonity.companions.common.entity.projectile.FrogEggProjectile;
import dev.xylonity.companions.common.entity.summon.BubbleFrogEntity;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class BubbleFrogAttackGoal
extends AbstractCorneliusSummonAttackGoal {
    public BubbleFrogAttackGoal(CompanionSummonEntity summon, int minCd, int maxCd) {
        super(summon, 48, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.summon.setNoMovement(true);
    }

    @Override
    public void stop() {
        super.stop();
        this.summon.setNoMovement(false);
    }

    @Override
    public void tick() {
        LivingEntity target = this.summon.getTarget();
        if (target != null) {
            this.summon.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
        if (this.attackTicks % 2 == 0 && this.attackTicks > 7 && this.attackTicks < 40 && target != null && target.isAlive()) {
            this.performAttack(target);
        }
        if (this.attackTicks == 2) {
            this.summon.playSound(CompanionsSounds.SMALL_FROG_SHOOT.get());
        }
        ++this.attackTicks;
    }

    @Override
    protected int getAttackType() {
        return 1;
    }

    @Override
    protected void performAttack(LivingEntity target) {
        FrogEggProjectile projectile = (FrogEggProjectile)CompanionsEntities.FROG_EGG_PROJECTILE.get().create(this.summon.level());
        if (projectile != null) {
            Vec3 basePos = this.summon.position().add(0.0, 0.5 + Math.random() * 0.4, 0.0);
            Vec3 targetPos = target.position().add(0.0, (double)target.getEyeHeight(), 0.0);
            Vec3 dir = targetPos.subtract(basePos).normalize();
            Vec3 spawnPos = basePos.add(new Vec3(-dir.z, 0.0, dir.x).normalize().scale((double)(-0.5f + this.summon.level().random.nextFloat())));
            projectile.setOwner((Entity)this.summon);
            projectile.setTarget(target);
            projectile.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
            projectile.setDeltaMovement(targetPos.subtract(spawnPos).normalize().scale((double)projectile.getDefaultSpeed()));
            projectile.setNoGravity(true);
            this.summon.level().addFreshEntity((Entity)projectile);
        }
    }

    @Override
    protected int attackDelay() {
        return 0;
    }

    @Override
    protected Class<? extends CompanionSummonEntity> summonType() {
        return BubbleFrogEntity.class;
    }
}

