/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.cornelius.summon.goal;

import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import dev.xylonity.companions.common.entity.ai.cornelius.summon.AbstractCorneliusSummonAttackGoal;
import dev.xylonity.companions.common.entity.summon.NetherBullfrogEntity;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class NetherBullfrogSlashLeftGoal
extends AbstractCorneliusSummonAttackGoal {
    public NetherBullfrogSlashLeftGoal(CompanionSummonEntity summon, int minCd, int maxCd) {
        super(summon, 21, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.summon.setNoMovement(true);
        LivingEntity target = this.summon.getTarget();
        if (target != null) {
            this.summon.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.summon.setNoMovement(false);
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.summon.getTarget() != null && this.summon.distanceToSqr((Entity)this.summon.getTarget()) < 4.5;
    }

    @Override
    protected int getAttackType() {
        return 1;
    }

    @Override
    protected void performAttack(LivingEntity target) {
        for (LivingEntity e : this.summon.level().getEntitiesOfClass(LivingEntity.class, this.summon.getBoundingBox().inflate(2.5))) {
            if (Util.areEntitiesLinked((Entity)e, (Entity)this.summon) || !NetherBullfrogSlashLeftGoal.isEntityInFront((LivingEntity)this.summon, (Entity)e, 220.0)) continue;
            this.summon.doHurtTarget((Entity)e);
        }
        this.summon.playSound(CompanionsSounds.NETHER_BULLFROG_SLASH.get());
    }

    @Override
    protected int attackDelay() {
        return 11;
    }

    @Override
    protected Class<? extends CompanionSummonEntity> summonType() {
        return NetherBullfrogEntity.class;
    }
}

