/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.cornelius.summon.goal;

import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import dev.xylonity.companions.common.entity.ai.cornelius.summon.AbstractCorneliusSummonAttackGoal;
import dev.xylonity.companions.common.entity.summon.NetherBullfrogEntity;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class NetherBullfrogSpinSlashGoal
extends AbstractCorneliusSummonAttackGoal {
    public NetherBullfrogSpinSlashGoal(CompanionSummonEntity summon, int minCd, int maxCd) {
        super(summon, 41, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.summon.setNoMovement(true);
        LivingEntity target = this.summon.getTarget();
        if (target != null) {
            this.summon.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.summon.setNoMovement(false);
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.summon.getTarget() != null && this.summon.distanceTo((Entity)this.summon.getTarget()) < 3.0f;
    }

    @Override
    public void tick() {
        LivingEntity target = this.summon.getTarget();
        if (target != null) {
            this.summon.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
        if (this.attackTicks > 10 && this.attackTicks % 10 == 0 && this.attackTicks < 33 && target != null && target.isAlive()) {
            this.performAttack(target);
            this.summon.playSound(CompanionsSounds.NETHER_BULLFROG_SLASH.get());
        }
        ++this.attackTicks;
    }

    @Override
    protected int getAttackType() {
        return 3;
    }

    @Override
    protected void performAttack(LivingEntity target) {
        for (LivingEntity e : this.summon.level().getEntitiesOfClass(LivingEntity.class, this.summon.getBoundingBox().inflate(2.5))) {
            if (Util.areEntitiesLinked((Entity)e, (Entity)this.summon)) continue;
            e.hurt(this.summon.damageSources().mobAttack((LivingEntity)this.summon), 4.0f);
        }
    }

    @Override
    protected int attackDelay() {
        return 26;
    }

    @Override
    protected Class<? extends CompanionSummonEntity> summonType() {
        return NetherBullfrogEntity.class;
    }
}

