/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.mage.allay.goal;

import dev.xylonity.companions.common.entity.companion.GoldenAllayEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;

public class GoldenAllayRandomMoveGoal
extends Goal {
    private final GoldenAllayEntity allay;

    public GoldenAllayRandomMoveGoal(GoldenAllayEntity allay) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        this.allay = allay;
    }

    public boolean canUse() {
        if (this.allay.getState() == 1 || this.allay.getState() == 3 || this.allay.getState() == 5) {
            return false;
        }
        return !this.allay.getMoveControl().hasWanted() && this.allay.getRandom().nextInt(GoldenAllayRandomMoveGoal.reducedTickDelay((int)7)) == 0;
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void tick() {
        BlockPos pos = this.allay.getOnPos();
        for (int i = 0; i < 3; ++i) {
            BlockPos offset = pos.offset(this.allay.getRandom().nextInt(15) - 7, this.allay.getRandom().nextInt(7) - 3, this.allay.getRandom().nextInt(15) - 7);
            if (!this.allay.level().isEmptyBlock(offset)) continue;
            this.allay.getMoveControl().setWantedPosition((double)offset.getX() + 0.5, (double)offset.getY() + 0.5, (double)offset.getZ() + 0.5, 0.25);
            if (this.allay.getTarget() != null) break;
            this.allay.getLookControl().setLookAt((double)offset.getX() + 0.5, (double)offset.getY() + 0.5, (double)offset.getZ() + 0.5, 180.0f, 20.0f);
            break;
        }
    }
}

