/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.mage.goal;

import dev.xylonity.companions.common.entity.ai.mage.AbstractSoulMageAttackGoal;
import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import dev.xylonity.companions.common.entity.projectile.StoneSpikeProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.knightlib.api.TickScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class SoulMageStoneSpikesGoal
extends AbstractSoulMageAttackGoal {
    public SoulMageStoneSpikesGoal(SoulMageEntity soulMage, int minCd, int maxCd) {
        super(soulMage, minCd, maxCd, "STONE_SPIKES");
    }

    @Override
    protected void performAttack(LivingEntity target) {
        if (target != null) {
            Vec3 baseDir = target.position().subtract(this.soulMage.position()).normalize();
            int spikes = 12;
            this.spawnSpikeRow(baseDir, spikes);
            this.spawnSpikeRow(Util.rotateHorizontalDirection(baseDir, -25.0), (int)((double)spikes * 0.7));
            this.spawnSpikeRow(Util.rotateHorizontalDirection(baseDir, 25.0), (int)((double)spikes * 0.7));
        }
    }

    private void spawnSpikeRow(Vec3 direction, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 pos = this.soulMage.position().add(direction.scale(1.5 + (double)i * 1.5));
            int y = this.soulMage.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, new BlockPos((int)pos.x, 0, (int)pos.z)).getY();
            StoneSpikeProjectile spike = (StoneSpikeProjectile)CompanionsEntities.STONE_SPIKE_PROJECTILE.get().create(this.soulMage.level());
            if (spike == null) continue;
            spike.moveTo(pos.x, Util.findValidSpawnPos(new BlockPos((int)pos.x, y, (int)pos.z), this.soulMage.level()).getY(), pos.z, this.soulMage.getYRot(), 0.0f);
            spike.setOwner((Entity)this.soulMage);
            if (i == 0) {
                this.soulMage.level().addFreshEntity((Entity)spike);
                continue;
            }
            TickScheduler.scheduleBoth((Level)this.soulMage.level(), () -> this.soulMage.level().addFreshEntity((Entity)spike), (int)(i * 2));
        }
    }

    @Override
    protected boolean hasRequiredBook() {
        for (int i = 0; i < this.soulMage.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.soulMage.inventory.getItem(i);
            if (stack.getItem() != CompanionsItems.BOOK_STONE_SPIKES.get()) continue;
            return true;
        }
        return false;
    }
}

