/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.mankh;

import dev.xylonity.companions.common.entity.companion.MankhEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public abstract class AbstractMankhAttackGoal
extends Goal {
    protected final MankhEntity mankh;
    protected final int attackDuration;
    protected final int minCooldown;
    protected final int maxCooldown;
    protected int attackTicks;
    protected int nextUseTick;
    protected boolean started;

    public AbstractMankhAttackGoal(MankhEntity mankh, int attackDuration, int minCd, int maxCd) {
        this.mankh = mankh;
        this.attackDuration = attackDuration;
        this.minCooldown = minCd;
        this.maxCooldown = maxCd;
        this.nextUseTick = -1;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.mankh.getAttackType() != 0) {
            return false;
        }
        if (this.mankh.getTarget() == null) {
            return false;
        }
        if (this.mankh.getMainAction() != 1) {
            return false;
        }
        if (this.nextUseTick < 0) {
            this.nextUseTick = this.mankh.tickCount + this.minCooldown + this.mankh.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
            return false;
        }
        return this.mankh.tickCount >= this.nextUseTick;
    }

    public boolean canContinueToUse() {
        return this.started && this.attackTicks < this.attackDuration;
    }

    public void start() {
        this.attackTicks = 0;
        this.started = true;
        this.mankh.setAttackType(this.attackType());
    }

    public void stop() {
        this.started = false;
        this.mankh.setAttackType(0);
        int cd = this.minCooldown + this.mankh.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
        this.nextUseTick = this.mankh.tickCount + cd;
    }

    public void tick() {
        LivingEntity target = this.mankh.getTarget();
        if (target != null) {
            this.mankh.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
        if (this.attackTicks == this.attackDelay() && target != null && target.isAlive()) {
            this.performAttack(target);
        }
        ++this.attackTicks;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    protected abstract void performAttack(LivingEntity var1);

    protected abstract int attackDelay();

    protected abstract int attackType();
}

