/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.minion.tamable.gargoyle;

import dev.xylonity.companions.common.entity.ai.minion.tamable.AbstractMinionAttackGoal;
import dev.xylonity.companions.common.entity.companion.MinionEntity;
import dev.xylonity.companions.common.entity.projectile.StoneSpikeProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.knightlib.api.TickScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class GargoyleSpellAttackGoal
extends AbstractMinionAttackGoal {
    public GargoyleSpellAttackGoal(MinionEntity minion, int minCd, int maxCd) {
        super(minion, 21, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.minion.setNoMovement(true);
    }

    @Override
    public void stop() {
        super.stop();
        this.minion.setNoMovement(false);
    }

    @Override
    protected void performAttack(LivingEntity target) {
        Vec3 baseDir = target.position().subtract(this.minion.position()).normalize();
        int spikes = 12;
        this.spawnSpikeRow(baseDir, spikes);
        this.spawnSpikeRow(Util.rotateHorizontalDirection(baseDir, -25.0), (int)((double)spikes * 0.7));
        this.spawnSpikeRow(Util.rotateHorizontalDirection(baseDir, 25.0), (int)((double)spikes * 0.7));
    }

    private void spawnSpikeRow(Vec3 direction, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 pos = this.minion.position().add(direction.scale(1.5 + (double)i * 1.5));
            int y = this.minion.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, new BlockPos((int)pos.x, 0, (int)pos.z)).getY();
            StoneSpikeProjectile spike = (StoneSpikeProjectile)CompanionsEntities.STONE_SPIKE_PROJECTILE.get().create(this.minion.level());
            if (spike == null) continue;
            spike.moveTo(pos.x, Util.findValidSpawnPos(new BlockPos((int)pos.x, y, (int)pos.z), this.minion.level()).getY(), pos.z, this.minion.getYRot(), 0.0f);
            spike.setOwner((Entity)this.minion);
            if (i == 0) {
                this.minion.level().addFreshEntity((Entity)spike);
                continue;
            }
            TickScheduler.scheduleBoth((Level)this.minion.level(), () -> this.minion.level().addFreshEntity((Entity)spike), (int)(i * 2));
        }
    }

    @Override
    protected int attackDelay() {
        return 12;
    }

    @Override
    protected String variant() {
        return MinionEntity.Variant.END.getName();
    }

    @Override
    protected int attackType() {
        return 1;
    }
}

