/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.pontiff.goal;

import dev.xylonity.companions.common.entity.ai.pontiff.AbstractSacredPontiffAttackGoal;
import dev.xylonity.companions.common.entity.hostile.SacredPontiffEntity;
import dev.xylonity.companions.common.entity.projectile.HolinessNaginataProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class HolinessDoubleThrowAttackGoal
extends AbstractSacredPontiffAttackGoal {
    public HolinessDoubleThrowAttackGoal(SacredPontiffEntity boss, int minCd, int maxCd) {
        super(boss, 85, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.pontiff.setNoMovement(true);
        this.pontiff.setShouldLookAtTarget(false);
        this.pontiff.playSound(CompanionsSounds.HOLINESS_FLY_OFF.get());
    }

    @Override
    public void stop() {
        super.stop();
        this.pontiff.setNoMovement(false);
        this.pontiff.setShouldLookAtTarget(true);
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.pontiff.getTarget() != null && this.pontiff.distanceTo((Entity)this.pontiff.getTarget()) < 25.0f && HolinessDoubleThrowAttackGoal.isEntityInFront((LivingEntity)this.pontiff, (Entity)this.pontiff.getTarget(), 200.0);
    }

    @Override
    protected int getAttackType() {
        return 3;
    }

    @Override
    public void tick() {
        LivingEntity target = this.pontiff.getTarget();
        if (this.attackTicks == this.attackDelay() + 14 && target != null && target.isAlive()) {
            this.performSecondAttack(target);
        }
        super.tick();
    }

    @Override
    protected void performAttack(LivingEntity target) {
        Vec3 basePos = this.pontiff.position().add(0.0, (double)(this.pontiff.getEyeHeight() + 4.0f), 0.0);
        Vec3 targetPos = target.position().add(0.0, (double)target.getEyeHeight(), 0.0);
        Vec3 direction = targetPos.subtract(basePos).normalize();
        Vec3 perpen = new Vec3(-direction.z, 0.0, direction.x).normalize();
        this.spawnNaginata(basePos, perpen, -1.5f, targetPos, (double)2.8f + 0.5 * (double)new Random().nextFloat());
    }

    protected void performSecondAttack(LivingEntity target) {
        Vec3 basePos = this.pontiff.position().add(0.0, (double)(this.pontiff.getEyeHeight() + 4.0f), 0.0);
        Vec3 targetPos = target.position().add(0.0, (double)target.getEyeHeight(), 0.0);
        Vec3 direction = targetPos.subtract(basePos).normalize();
        Vec3 perpen = new Vec3(-direction.z, 0.0, direction.x).normalize();
        this.spawnNaginata(basePos, perpen, 1.5f, targetPos, (double)4.8f + 0.5 * (double)new Random().nextFloat());
    }

    private void spawnNaginata(Vec3 basePos, Vec3 perpen, float side, Vec3 targetPos, double speed) {
        Vec3 spawnPos = basePos.add(perpen.scale((double)side));
        Vec3 aimDir = targetPos.subtract(spawnPos).normalize();
        HolinessNaginataProjectile naginata = (HolinessNaginataProjectile)CompanionsEntities.HOLINESS_NAGINATA.get().create(this.pontiff.level());
        if (naginata != null) {
            naginata.setOwner((Entity)this.pontiff);
            naginata.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
            naginata.setDeltaMovement(aimDir.scale(speed));
            naginata.refreshOrientation();
            naginata.setInvisible(true);
            this.pontiff.level().addFreshEntity((Entity)naginata);
        }
    }

    @Override
    protected int attackDelay() {
        return 40;
    }

    @Override
    protected int attackState() {
        return 6;
    }
}

