/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.puppet.glove;

import dev.xylonity.companions.common.entity.companion.PuppetGloveEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public abstract class AbstractPuppetGloveAttackGoal
extends Goal {
    protected final PuppetGloveEntity glove;
    private final int attackDuration;
    private final int minCooldown;
    private final int maxCooldown;
    protected int attackTicks;
    protected int nextUseTick;
    protected boolean started;

    public AbstractPuppetGloveAttackGoal(PuppetGloveEntity glove, int attackDuration, int minCd, int maxCd) {
        this.glove = glove;
        this.attackDuration = attackDuration;
        this.minCooldown = minCd;
        this.maxCooldown = maxCd;
        this.nextUseTick = -1;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.glove.isAttacking()) {
            return false;
        }
        if (this.glove.getTarget() == null) {
            return false;
        }
        if (this.glove.getMainAction() != 1) {
            return false;
        }
        if (this.nextUseTick < 0) {
            this.nextUseTick = this.glove.tickCount + this.minCooldown + this.glove.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
            return false;
        }
        return this.glove.tickCount >= this.nextUseTick;
    }

    public boolean canContinueToUse() {
        return this.started && this.attackTicks < this.attackDuration;
    }

    public void start() {
        this.attackTicks = 0;
        this.started = true;
        this.glove.setAttacking(true);
    }

    public void stop() {
        this.started = false;
        this.glove.setAttacking(false);
        int cd = this.minCooldown + this.glove.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
        this.nextUseTick = this.glove.tickCount + cd;
    }

    public void tick() {
        LivingEntity target = this.glove.getTarget();
        if (target != null) {
            this.glove.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
        if (this.attackTicks == this.attackDelay() && target != null && target.isAlive()) {
            this.performAttack(target);
        }
        ++this.attackTicks;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    protected abstract void performAttack(LivingEntity var1);

    protected abstract int attackDelay();
}

