/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.puppet.glove.goal;

import dev.xylonity.companions.common.entity.ai.puppet.glove.AbstractPuppetGloveAttackGoal;
import dev.xylonity.companions.common.entity.companion.PuppetGloveEntity;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class PuppetGloveAttackGoal
extends AbstractPuppetGloveAttackGoal {
    public PuppetGloveAttackGoal(PuppetGloveEntity glove, int minCd, int maxCd) {
        super(glove, 15, minCd, maxCd);
    }

    @Override
    public boolean canUse() {
        return super.canUse() && !this.glove.isTransforming();
    }

    @Override
    public void start() {
        super.start();
        this.glove.setNoMovement(true);
        this.glove.playSound(CompanionsSounds.PUPPET_GLOVE_SHOOT.get());
    }

    @Override
    public void stop() {
        super.stop();
        this.glove.setNoMovement(false);
    }

    @Override
    protected void performAttack(LivingEntity target) {
        if (this.glove.hasLineOfSight((Entity)target) && !Util.areEntitiesLinked((Entity)this.glove, (Entity)target)) {
            this.glove.doHurtTarget((Entity)target);
        }
    }

    @Override
    protected int attackDelay() {
        return 7;
    }
}

