/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.puppet.goal;

import dev.xylonity.companions.common.entity.ai.puppet.AbstractPuppetRightAttackGoal;
import dev.xylonity.companions.common.entity.companion.PuppetEntity;
import dev.xylonity.companions.common.entity.projectile.StakeProjectile;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class PuppetRightCannonAttackGoal
extends AbstractPuppetRightAttackGoal {
    public PuppetRightCannonAttackGoal(PuppetEntity puppet, int minCd, int maxCd) {
        super(puppet, minCd, maxCd, "CANNON");
    }

    @Override
    protected void performAttack(LivingEntity target) {
        Vec3 lookVec = this.puppet.getLookAngle();
        Vec3 vec3 = new Vec3(-lookVec.z, 0.0, lookVec.x).normalize();
        Vec3 offset = vec3.scale(0.5).add(0.0, 0.2, 0.0);
        Vec3 startPos = new Vec3(this.puppet.getX(), this.puppet.getY(), this.puppet.getZ()).add(offset);
        Vec3 targetPos = target.getEyePosition(1.0f);
        Vec3 direction = targetPos.subtract(startPos).normalize();
        StakeProjectile stake = new StakeProjectile(this.puppet.level(), (LivingEntity)this.puppet);
        stake.setPos(startPos.x, startPos.y, startPos.z);
        stake.shoot(direction.x, direction.y, direction.z, 1.6f, 0.0f);
        this.puppet.level().addFreshEntity((Entity)stake);
    }

    @Override
    public void start() {
        super.start();
        this.puppet.level().playSound(null, this.puppet.blockPosition(), CompanionsSounds.PUPPET_ATTACK_CANON.get(), this.puppet.getSoundSource(), 4.0f, 1.0f);
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.puppet.getOwner() != null;
    }

    @Override
    protected boolean hasRequiredArm() {
        return this.puppet.inventory.getItem(0).is(CompanionsItems.CANNON_ARM.get());
    }
}

