/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.shade.sword.goal;

import dev.xylonity.companions.common.entity.ShadeEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class ShadeSwordFollowOwnerGoal
extends Goal {
    private static final double ORBIT_RADIUS = 3.5;
    private static final float FLOAT_Y = 0.7f;
    private final ShadeEntity shade;
    private LivingEntity owner;
    private Vec3 center = null;
    private double angle = 0.0;

    public ShadeSwordFollowOwnerGoal(ShadeEntity shade) {
        this.shade = shade;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.shade.isSpawning()) {
            return false;
        }
        this.owner = this.shade.getOwner();
        return this.owner != null && !this.owner.isSpectator();
    }

    public boolean canContinueToUse() {
        return this.canUse() && this.owner.getLastHurtMob() == null;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.center == null) {
            this.center = this.shade.position();
            this.angle = Math.atan2(this.shade.getZ() - this.center.z, this.shade.getX() - this.center.x);
        } else {
            this.center = this.center.lerp(new Vec3(this.owner.getX(), this.owner.getY() + (double)(this.owner.getBbHeight() * 0.7f), this.owner.getZ()), 0.08);
        }
        this.angle = (this.angle + 0.041887902047863905) % (Math.PI * 2);
        Vec3 nextPos = this.shade.position().lerp(this.center.add(3.5 * Math.cos(this.angle), 0.0, 3.5 * Math.sin(this.angle)), 0.15);
        this.shade.setPos(nextPos.x, nextPos.y, nextPos.z);
        this.shade.setDeltaMovement(Vec3.ZERO);
        float yaw = (float)Math.toDegrees(this.angle + 1.5707963267948966);
        this.shade.setYRot(yaw);
        this.shade.setYBodyRot(yaw);
    }
}

