/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.teddy.goal;

import dev.xylonity.companions.common.entity.ai.teddy.AbstractTeddyAttackGoal;
import dev.xylonity.companions.common.entity.companion.TeddyEntity;
import dev.xylonity.companions.registry.CompanionsEffects;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.Random;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class TeddyAttackGoal
extends AbstractTeddyAttackGoal {
    public TeddyAttackGoal(TeddyEntity teddy, int minCd, int maxCd) {
        super(teddy, 15, minCd, maxCd);
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.teddy.getTarget() != null && this.teddy.distanceTo((Entity)this.teddy.getTarget()) <= 3.0f && this.teddy.getPhase() == 1;
    }

    @Override
    public void start() {
        super.start();
        this.teddy.setNoMovement(true);
    }

    @Override
    public void stop() {
        super.stop();
        this.teddy.setNoMovement(false);
    }

    @Override
    protected void performAttack(LivingEntity target) {
        if (this.teddy.hasLineOfSight((Entity)target)) {
            this.teddy.playSound(CompanionsSounds.TEDDY_ATTACK.get());
            this.teddy.doHurtTarget((Entity)target);
            Random random = new Random();
            if (random.nextFloat() < 0.35f) {
                target.addEffect(new MobEffectInstance(CompanionsEffects.VOODOO, new Random().nextInt(100, 300), 0, true, true, true));
            }
        }
    }

    @Override
    protected int attackDelay() {
        return 4;
    }

    @Override
    protected int phase() {
        return 1;
    }

    @Override
    protected int getAttackType() {
        return 1;
    }
}

