/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.container.PuppetContainerMenu;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetApproachTargetGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetLeftBladeAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetLeftCannonAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetLeftMutantAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetLeftWhipAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetRightBladeAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetRightCannonAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetRightMutantAttackGoal;
import dev.xylonity.companions.common.entity.ai.puppet.goal.PuppetRightWhipAttackGoal;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class PuppetEntity
extends CompanionEntity
implements RangedAttackMob,
ContainerListener {
    public SimpleContainer inventory;
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation ATTACK_L = RawAnimation.begin().thenPlay("attack_l");
    private final RawAnimation ATTACK_R = RawAnimation.begin().thenPlay("attack_r");
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.defineId(PuppetEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<String> ATTACK_ANIMATION_NAME = SynchedEntityData.defineId(PuppetEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Boolean> IS_ATTACKING_RIGHT = SynchedEntityData.defineId(PuppetEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_ATTACKING_LEFT = SynchedEntityData.defineId(PuppetEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ACTIVE_ARMS = SynchedEntityData.defineId(PuppetEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> ARM_NAMES = SynchedEntityData.defineId(PuppetEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private final ItemStack[] lastStacks = new ItemStack[]{ItemStack.EMPTY.copy(), ItemStack.EMPTY.copy()};
    private static final EntityDataAccessor<String> CURRENT_ATTACK_TYPE = SynchedEntityData.defineId(PuppetEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public PuppetEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.createInventory();
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void createInventory() {
        SimpleContainer oldInv = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (oldInv != null) {
            int min = Math.min(oldInv.getContainerSize(), this.inventory.getContainerSize());
            for (int i = 0; i < min; ++i) {
                ItemStack stack = oldInv.getItem(i);
                this.inventory.setItem(i, stack.copy());
            }
        }
        this.inventory.addListener((ContainerListener)this);
        this.updateContainerEquipment();
    }

    protected int getInventorySize() {
        return 2;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new PuppetRightCannonAttackGoal(this, 10, 50));
        this.goalSelector.addGoal(2, (Goal)new PuppetRightBladeAttackGoal(this, 10, 50));
        this.goalSelector.addGoal(2, (Goal)new PuppetRightMutantAttackGoal(this, 10, 50));
        this.goalSelector.addGoal(2, (Goal)new PuppetRightWhipAttackGoal(this, 10, 50));
        this.goalSelector.addGoal(2, (Goal)new PuppetLeftCannonAttackGoal(this, 10, 50));
        this.goalSelector.addGoal(2, (Goal)new PuppetLeftBladeAttackGoal(this, 10, 50));
        this.goalSelector.addGoal(2, (Goal)new PuppetLeftMutantAttackGoal(this, 10, 50));
        this.goalSelector.addGoal(2, (Goal)new PuppetLeftWhipAttackGoal(this, 10, 50));
        this.goalSelector.addGoal(3, (Goal)new PuppetApproachTargetGoal(this, 0.5, 0.4f, 1.25f));
        this.goalSelector.addGoal(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 0.6, 6.0f, 2.0f));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Optional h = this.getBoundingBox().clip(player.getEyePosition(), player.getEyePosition(1.0f).add(player.getLookAngle().scale(5.0)));
            if (h.isPresent() && ((Vec3)h.get()).y - this.getBoundingBox().minY < 2.0) {
                return false;
            }
        }
        boolean ret = super.hurt(source, amount);
        if (!this.level().isClientSide && amount > 4.0f && this.hasArm(CompanionsItems.MUTANT_ARM.get()) && this.getTarget() != null) {
            this.spawnMutantParticles(15);
            this.tpOppositeSide();
            this.spawnMutantParticles(15);
        }
        return ret;
    }

    private void spawnMutantParticles(int amount) {
        for (int i = 0; i < amount; ++i) {
            double dx = (this.random.nextDouble() - 0.5) * 2.0;
            double dy = (this.random.nextDouble() - 0.5) * 2.0;
            double dz = (this.random.nextDouble() - 0.5) * 2.0;
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.sendParticles((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY() + 1.0, this.getZ(), 1, dx, dy, dz, 0.1);
            if (i % 5 != 0) continue;
            level2.sendParticles((ParticleOptions)CompanionsParticles.TEDDY_TRANSFORMATION.get(), this.getX(), this.getY() + 1.0, this.getZ(), 1, dx, dy, dz, 0.2);
        }
    }

    private void tpOppositeSide() {
        LivingEntity target = this.getTarget();
        if (target == null) {
            return;
        }
        Vec3 pos = target.position();
        Vec3 newPos = pos.subtract(this.position().x - pos.x, 0.0, this.position().z - pos.z);
        if (this.isValidTeleportPos(newPos)) {
            this.setPos(newPos.x, this.position().y, newPos.z);
        }
    }

    private boolean isValidTeleportPos(Vec3 newPos) {
        BlockPos feet = new BlockPos((int)newPos.x, (int)newPos.y, (int)newPos.z);
        BlockPos head = new BlockPos((int)newPos.x, (int)newPos.y + 1, (int)newPos.z);
        BlockPos floor = new BlockPos((int)newPos.x, (int)newPos.y - 1, (int)newPos.z);
        boolean f1 = this.level().getBlockState(feet).isAir() && this.level().getBlockState(head).isAir();
        boolean f2 = this.level().getBlockState(floor).isSolidRender((BlockGetter)this.level(), floor);
        return f1 && f2;
    }

    public boolean hasArm(Item armItem) {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (stack.isEmpty() || stack.getItem() != armItem) continue;
            return true;
        }
        return false;
    }

    public static AttributeSupplier setAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, CompanionsConfig.PUPPET_MAX_LIFE).add(Attributes.ATTACK_DAMAGE, CompanionsConfig.PUPPET_DAMAGE).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.55f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    public void setActiveArms(int candleCount) {
        this.entityData.set(ACTIVE_ARMS, (Object)candleCount);
    }

    public int getActiveArms() {
        return (Integer)this.entityData.get(ACTIVE_ARMS);
    }

    public boolean isAttackingRight() {
        return (Boolean)this.entityData.get(IS_ATTACKING_RIGHT);
    }

    public void setAttackingRight(boolean attacking) {
        this.entityData.set(IS_ATTACKING_RIGHT, (Object)attacking);
    }

    public boolean isAttackingLeft() {
        return (Boolean)this.entityData.get(IS_ATTACKING_LEFT);
    }

    public void setAttackingLeft(boolean attacking) {
        this.entityData.set(IS_ATTACKING_LEFT, (Object)attacking);
    }

    public void setArmNames(String armNames) {
        this.entityData.set(ARM_NAMES, (Object)armNames);
    }

    public String getArmNames() {
        return (String)this.entityData.get(ARM_NAMES);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_ATTACKING_RIGHT, (Object)false);
        builder.define(IS_ATTACKING_LEFT, (Object)false);
        builder.define(DATA_ID_FLAGS, (Object)0);
        builder.define(ATTACK_ANIMATION_NAME, (Object)"");
        builder.define(ACTIVE_ARMS, (Object)0);
        builder.define(CURRENT_ATTACK_TYPE, (Object)"NONE");
        builder.define(ARM_NAMES, (Object)"none,none");
    }

    @Nullable
    public LivingEntity getOwner() {
        return super.getOwner();
    }

    @NotNull
    public InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        if (this.isTame() && this.getOwner() == player && player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND) {
            if (!this.level().isClientSide) {
                player.openMenu(new MenuProvider(){

                    public Component getDisplayName() {
                        return PuppetEntity.this.getName();
                    }

                    @Nullable
                    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
                        return new PuppetContainerMenu(i, inventory, PuppetEntity.this);
                    }
                }, buf -> buf.writeInt(this.getId()));
                this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), 0.5f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.inventory.fromTag(pCompound.getList("Inventory", 10), (HolderLookup.Provider)this.level().registryAccess());
        this.updateContainerEquipment();
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.put("Inventory", (Tag)this.inventory.createTag((HolderLookup.Provider)this.level().registryAccess()));
    }

    @Override
    protected boolean canThisCompanionWork() {
        return true;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 1;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.PUPPET_KEEP_CHUNK_LOADED;
    }

    public void performRangedAttack(@NotNull LivingEntity target, float v) {
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return CompanionsSounds.PUPPET_HURT.get();
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.playSound(CompanionsSounds.PUPPET_WALK.get(), 0.45f, 1.0f);
    }

    public void containerChanged(@NotNull Container container) {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack old = this.lastStacks[i];
            ItemStack now = this.inventory.getItem(i);
            if (ItemStack.matches((ItemStack)old, (ItemStack)now)) continue;
            this.lastStacks[i] = now.copy();
            if (now.isEmpty()) continue;
            Item item = now.getItem();
            if (item == CompanionsItems.CANNON_ARM.get()) {
                this.playSound(CompanionsSounds.PUPPET_EQUIP_CANON.get(), 0.75f, 1.0f);
                continue;
            }
            if (item == CompanionsItems.MUTANT_ARM.get()) {
                this.playSound(CompanionsSounds.PUPPET_EQUIP_MUTANT.get(), 0.75f, 1.0f);
                continue;
            }
            if (item == CompanionsItems.WHIP_ARM.get()) {
                this.playSound(CompanionsSounds.PUPPET_EQUIP_WHIP.get(), 0.75f, 1.0f);
                continue;
            }
            if (item != CompanionsItems.BLADE_ARM.get()) continue;
            this.playSound(CompanionsSounds.PUPPET_EQUIP_BLADE.get(), 0.75f, 1.0f);
        }
        this.updateContainerEquipment();
    }

    protected void updateContainerEquipment() {
        if (!this.level().isClientSide) {
            Item item;
            this.setFlag(!this.inventory.getItem(0).isEmpty());
            int arms = 0;
            String leftArm = "none";
            String rightArm = "none";
            if (!this.inventory.getItem(0).isEmpty()) {
                arms |= 2;
                item = this.inventory.getItem(0).getItem();
                if (item == CompanionsItems.CANNON_ARM.get()) {
                    rightArm = "cannon";
                } else if (item == CompanionsItems.MUTANT_ARM.get()) {
                    rightArm = "mutant";
                } else if (item == CompanionsItems.WHIP_ARM.get()) {
                    rightArm = "whip";
                } else if (item == CompanionsItems.BLADE_ARM.get()) {
                    rightArm = "blade";
                }
            }
            if (!this.inventory.getItem(1).isEmpty()) {
                arms |= 1;
                item = this.inventory.getItem(1).getItem();
                if (item == CompanionsItems.CANNON_ARM.get()) {
                    leftArm = "cannon";
                } else if (item == CompanionsItems.MUTANT_ARM.get()) {
                    leftArm = "mutant";
                } else if (item == CompanionsItems.WHIP_ARM.get()) {
                    leftArm = "whip";
                } else if (item == CompanionsItems.BLADE_ARM.get()) {
                    leftArm = "blade";
                }
            }
            this.setActiveArms(arms);
            this.setArmNames(leftArm + "," + rightArm);
        }
    }

    protected void setFlag(boolean b) {
        byte $$2 = (Byte)this.entityData.get(DATA_ID_FLAGS);
        if (b) {
            this.entityData.set(DATA_ID_FLAGS, (Object)((byte)($$2 | 4)));
        } else {
            this.entityData.set(DATA_ID_FLAGS, (Object)((byte)($$2 & 0xFFFFFFFB)));
        }
    }

    protected void dropEquipment() {
        super.dropEquipment();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                ItemStack itemStack = this.inventory.getItem(i);
                if (itemStack.isEmpty()) continue;
                this.spawnAtLocation(itemStack);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "rightAttackcontroller", 1, this::rightAttackPredicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "leftAttackcontroller", 1, this::leftAttackPredicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 1, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState rightAttackPredicate(AnimationState<T> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED) && this.isAttackingRight()) {
            event.getController().forceAnimationReset();
            event.setAnimation(this.ATTACK_R);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState leftAttackPredicate(AnimationState<T> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED) && this.isAttackingLeft()) {
            event.getController().forceAnimationReset();
            event.setAnimation(this.ATTACK_L);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getMainAction() == 0) {
            event.setAnimation(this.SIT);
        } else if (event.isMoving()) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

