/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ShadeEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.entity.ai.shade.sword.ShadeSwordMoveControl;
import dev.xylonity.companions.common.entity.ai.shade.sword.goal.ShadeSwordFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.shade.sword.goal.ShadeSwordFollowTargetGoal;
import dev.xylonity.companions.common.entity.ai.shade.sword.goal.ShadeSwordGroundAttackGoal;
import dev.xylonity.companions.common.entity.ai.shade.sword.goal.ShadeSwordMeleeAttackGoal;
import dev.xylonity.companions.common.entity.ai.shade.sword.goal.ShadeSwordSpinAttackGoal;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.TickScheduler;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class ShadeSwordEntity
extends ShadeEntity {
    private final RawAnimation SPAWN = RawAnimation.begin().thenPlay("spawn");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation ATTACK = RawAnimation.begin().thenPlay("attack");
    private final RawAnimation ATTACK2 = RawAnimation.begin().thenPlay("attack2");
    private final RawAnimation GROUND_ATTACK = RawAnimation.begin().thenPlay("nail_to_ground");
    private final RawAnimation SPIN_ATTACK = RawAnimation.begin().thenPlay("spin");
    private static final int ANIMATION_SPAWN_MAX_TICKS = 72;
    private boolean hasSpawned;

    public ShadeSwordEntity(EntityType<? extends CompanionEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.noPhysics = true;
        this.hasSpawned = false;
        this.setNoGravity(true);
        this.noCulling = true;
        this.moveControl = new ShadeSwordMoveControl(this);
    }

    @Override
    public int getMaxLifetime() {
        return CompanionsConfig.SHADOW_SWORD_LIFETIME;
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new ShadeSwordMeleeAttackGoal(this, 20, 60));
        this.goalSelector.addGoal(1, (Goal)new ShadeSwordSpinAttackGoal(this, 70, 200));
        this.goalSelector.addGoal(1, (Goal)new ShadeSwordGroundAttackGoal(this, 120, 300));
        this.goalSelector.addGoal(2, (Goal)new ShadeSwordFollowTargetGoal(this));
        this.goalSelector.addGoal(3, (Goal)new ShadeSwordFollowOwnerGoal(this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    protected void playHurtSound(@NotNull DamageSource pSource) {
        this.playSound(CompanionsSounds.SHADE_HURT.get());
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return CompanionsSounds.SHADE_IDLE.get();
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    public static AttributeSupplier setAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, CompanionsConfig.SHADOW_SWORD_MAX_LIFE).add(Attributes.ATTACK_DAMAGE, CompanionsConfig.SHADOW_SWORD_DAMAGE).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.55f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.hasSpawned) {
            TickScheduler.scheduleServer((Level)this.level(), () -> this.setIsSpawning(false), (int)72);
            TickScheduler.scheduleServer((Level)this.level(), () -> this.setInvisible(false), (int)5);
            this.hasSpawned = true;
        }
        if (this.tickCount % 6 == 0 && !this.isSpawning()) {
            double dx = (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
            double dy = (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
            double dz = (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.sendParticles((ParticleOptions)CompanionsParticles.SHADE_TRAIL.get(), this.getX(), this.getY() + (double)this.getBbHeight() * Math.random(), this.getZ(), 1, dx, dy, dz, 0.1);
            }
        }
        this.setLifetime(this.getLifetime() - 1);
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 2;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return false;
    }

    @Nullable
    public LivingEntity getOwner() {
        return super.getOwner();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.isSpawning()) {
            event.setAnimation(this.SPAWN);
        } else if (this.getAttackType() == 1) {
            event.setAnimation(this.ATTACK);
        } else if (this.getAttackType() == 2) {
            event.setAnimation(this.ATTACK2);
        } else if (this.getAttackType() == 3) {
            event.setAnimation(this.GROUND_ATTACK);
        } else if (this.getAttackType() == 4) {
            event.setAnimation(this.SPIN_ATTACK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    public void aiStep() {
        this.setNoMovement(this.getAttackType() != 0);
        super.aiStep();
    }
}

