/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionRandomStrollGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsLookAtPlayerGoal;
import dev.xylonity.companions.common.entity.ai.teddy.control.TeddyMoveControl;
import dev.xylonity.companions.common.entity.ai.teddy.goal.MutatedTeddyAttackGoal;
import dev.xylonity.companions.common.entity.ai.teddy.goal.MutatedTeddyFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.teddy.goal.MutatedTeddyFollowTargetGoal;
import dev.xylonity.companions.common.entity.ai.teddy.goal.MutatedTeddyRandomStrollGoal;
import dev.xylonity.companions.common.entity.ai.teddy.goal.TeddyApproachTargetGoal;
import dev.xylonity.companions.common.entity.ai.teddy.goal.TeddyAttackGoal;
import dev.xylonity.companions.common.entity.ai.teddy.goal.TeddyVoodooAttackGoal;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class TeddyEntity
extends CompanionEntity
implements TraceableEntity {
    private final RawAnimation LAY = RawAnimation.begin().thenPlay("lay");
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation SLEEP = RawAnimation.begin().thenPlay("sleep");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation STAB = RawAnimation.begin().thenPlay("stab");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation AUTO_STAB = RawAnimation.begin().thenPlay("auto_stab");
    private final RawAnimation TRANSFORM = RawAnimation.begin().thenPlay("transform");
    private final RawAnimation MUTATED_FLY = RawAnimation.begin().thenPlay("flying");
    private final RawAnimation MUTATED_ATTACK1 = RawAnimation.begin().thenPlay("attack");
    private final RawAnimation MUTATED_ATTACK2 = RawAnimation.begin().thenPlay("stab");
    private final RawAnimation MUTATED_SIT1 = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation MUTATED_SIT2 = RawAnimation.begin().thenPlay("laying");
    private final RawAnimation MUTATED_SIT3 = RawAnimation.begin().thenPlay("flying_sit");
    private final RawAnimation MUTATED_DEATH = RawAnimation.begin().thenPlay("death");
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.defineId(TeddyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.defineId(TeddyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SECOND_PHASE_COUNTER = SynchedEntityData.defineId(TeddyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_ON_AIR = SynchedEntityData.defineId(TeddyEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> TELEPORTED = SynchedEntityData.defineId(TeddyEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final int ANIMATION_TRANSFORM_MAX_TICKS = 200;
    private static final int ANIMATION_DEAD_MAX_TICKS = 64;

    public TeddyEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    public boolean getTeleported() {
        return (Boolean)this.entityData.get(TELEPORTED);
    }

    public void setTeleported(boolean teleported) {
        this.entityData.set(TELEPORTED, (Object)teleported);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal(this){

            public boolean canUse() {
                if (!TeddyEntity.this.isTame()) {
                    return false;
                }
                if (TeddyEntity.this.isInWaterOrBubble()) {
                    return false;
                }
                if (!TeddyEntity.this.onGround() && TeddyEntity.this.getPhase() == 1) {
                    return false;
                }
                if (TeddyEntity.this.getOwner() == null) {
                    return true;
                }
                return !(TeddyEntity.this.distanceToSqr((Entity)TeddyEntity.this.getOwner()) < 144.0 && TeddyEntity.this.getOwner().getLastHurtByMob() != null || !TeddyEntity.this.isOrderedToSit());
            }

            public void start() {
                super.start();
                if (TeddyEntity.this.getPhase() == 2) {
                    double currentX = TeddyEntity.this.getX();
                    double currentZ = TeddyEntity.this.getZ();
                    BlockPos groundPos = Util.findClosestGroundBelow(TeddyEntity.this, 3.0f);
                    if (groundPos != null) {
                        double y = (double)groundPos.getY() + 1.0;
                        TeddyEntity.this.teleportTo(currentX, y, currentZ);
                    }
                }
            }
        });
        this.goalSelector.addGoal(2, (Goal)new TeddyAttackGoal(this, 10, 30));
        this.goalSelector.addGoal(2, (Goal)new TeddyVoodooAttackGoal(this, 60, 200));
        this.goalSelector.addGoal(3, (Goal)new TeddyApproachTargetGoal(this, 0.45, 0.4f, 1.25f));
        this.goalSelector.addGoal(3, (Goal)new MutatedTeddyAttackGoal(this, 0, 15));
        this.goalSelector.addGoal(4, (Goal)new MutatedTeddyFollowTargetGoal(this));
        this.goalSelector.addGoal(5, (Goal)new MutatedTeddyRandomStrollGoal(this, 0.43f));
        this.goalSelector.addGoal(5, (Goal)new MutatedTeddyFollowOwnerGoal(this, 0.6, 3.0, 7.0, 0.18f));
        this.goalSelector.addGoal(5, (Goal)new CompanionFollowOwnerGoal(this, 0.6, 6.0f, 2.0f, false){

            @Override
            public boolean canUse() {
                return super.canUse() && TeddyEntity.this.getPhase() == 1;
            }
        });
        this.goalSelector.addGoal(5, (Goal)new CompanionRandomStrollGoal(this, 0.43){

            @Override
            public boolean canUse() {
                return super.canUse() && TeddyEntity.this.getPhase() == 1;
            }
        });
        this.goalSelector.addGoal(6, (Goal)new CompanionsLookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            @Override
            public boolean canUse() {
                return super.canUse() && TeddyEntity.this.getMainAction() != 0 && TeddyEntity.this.getPhase() == 1;
            }

            @Override
            public boolean canContinueToUse() {
                return super.canContinueToUse() && TeddyEntity.this.getMainAction() != 0 && TeddyEntity.this.getPhase() == 1;
            }
        });
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (this.getPhase() == 2 && source.is(DamageTypes.IN_WALL)) {
            return false;
        }
        boolean ret = super.hurt(source, amount);
        if (!this.level().isClientSide && amount > 4.0f && this.getPhase() == 2 && this.getTarget() != null) {
            this.spawnMutantParticles(25);
            this.tpOppositeSide();
            this.spawnMutantParticles(25);
        }
        return ret;
    }

    private void tpOppositeSide() {
        LivingEntity target = this.getTarget();
        if (target == null) {
            return;
        }
        Vec3 pos = target.position();
        Vec3 newPos = pos.subtract(this.position().x - pos.x, 0.0, this.position().z - pos.z);
        this.setPos(newPos.x, this.position().y, newPos.z);
        this.setTeleported(true);
    }

    public static AttributeSupplier setAttributes() {
        return CompanionEntity.createMobAttributes().add(Attributes.MAX_HEALTH, CompanionsConfig.TEDDY_MAX_LIFE).add(Attributes.ATTACK_DAMAGE, CompanionsConfig.TEDDY_DAMAGE).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.55f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    private void updateStats() {
        AttributeInstance damage;
        AttributeInstance maxHealth = this.getAttribute(Attributes.MAX_HEALTH);
        if (maxHealth != null) {
            maxHealth.setBaseValue(CompanionsConfig.TEDDY_MUTANT_MAX_LIFE);
        }
        if ((damage = this.getAttribute(Attributes.ATTACK_DAMAGE)) != null) {
            damage.setBaseValue(CompanionsConfig.TEDDY_MUTANT_DAMAGE);
        }
    }

    public int getPhase() {
        return (Integer)this.entityData.get(PHASE);
    }

    public void setPhase(int phase) {
        this.entityData.set(PHASE, (Object)phase);
    }

    public int getSecondPhaseCounter() {
        return (Integer)this.entityData.get(SECOND_PHASE_COUNTER);
    }

    public void setSecondPhaseCounter(int t) {
        this.entityData.set(SECOND_PHASE_COUNTER, (Object)t);
    }

    public int getAttackType() {
        return (Integer)this.entityData.get(ATTACK_TYPE);
    }

    public void setAttackType(int type) {
        this.entityData.set(ATTACK_TYPE, (Object)type);
    }

    public boolean getIsOnAir() {
        return (Boolean)this.entityData.get(IS_ON_AIR);
    }

    public void setIsOnAir(boolean isOnAir) {
        this.entityData.set(IS_ON_AIR, (Object)isOnAir);
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return this.getPhase() != 2 && super.causeFallDamage(pFallDistance, pMultiplier, pSource);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PHASE, (Object)1);
        builder.define(SECOND_PHASE_COUNTER, (Object)0);
        builder.define(ATTACK_TYPE, (Object)0);
        builder.define(IS_ON_AIR, (Object)false);
        builder.define(TELEPORTED, (Object)false);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getPhase() == 2) {
            this.setNoGravity(true);
        }
        if (this.getPhase() == 2 && !this.level().isClientSide && this.getMainAction() == 0) {
            this.setIsOnAir(this.level().getBlockState(this.blockPosition().below()).isAir());
        }
        if (this.getSecondPhaseCounter() != 0 && this.getSecondPhaseCounter() <= 200) {
            this.setTarget(null);
            this.setNoMovement(true);
            if (this.getSecondPhaseCounter() == 200) {
                this.setNoMovement(false);
                this.level().addParticle((ParticleOptions)CompanionsParticles.TEDDY_TRANSFORMATION_CLOUD.get(), true, this.getX(), this.getY() + (double)0.15f, this.getZ(), 0.0, 0.0, 0.0);
                this.spawnMutantParticles(50);
                this.setPhase(2);
                this.refreshDimensions();
                this.updateStats();
                this.playSound(CompanionsSounds.TEDDY_TRANSFORMATION.get());
                this.moveControl = new TeddyMoveControl(this);
            }
            this.setSecondPhaseCounter(this.getSecondPhaseCounter() + 1);
        }
        if (this.getPhase() == 2 && this.getOwner() != null && !this.getOwner().hasEffect(MobEffects.REGENERATION) && this.distanceToSqr((Entity)this.getOwner()) < 256.0) {
            this.getOwner().addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 0, true, true, true));
        }
        if (this.getPhase() == 2 && !this.level().isClientSide && CompanionsConfig.TEDDY_MUTANT_HEALS_OVER_TIME) {
            if (this.tickCount % 200 == 0) {
                this.heal(1.0f);
            }
            if (this.tickCount % 15 == 0 && (this.getMainAction() == 0 && this.getIsOnAir() || this.getMainAction() != 0)) {
                this.playSound(CompanionsSounds.MUTANT_TEDDY_FLAP_WINGS.get(), 0.4f, 1.0f);
            }
        }
    }

    private void spawnMutantParticles(int amount) {
        for (int i = 0; i < amount; ++i) {
            double dx = (this.random.nextDouble() - 0.5) * 2.0;
            double dy = (this.random.nextDouble() - 0.5) * 2.0;
            double dz = (this.random.nextDouble() - 0.5) * 2.0;
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.sendParticles((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY() + 1.0, this.getZ(), 1, dx, dy, dz, 0.1);
            if (i % 5 != 0) continue;
            level2.sendParticles((ParticleOptions)CompanionsParticles.TEDDY_TRANSFORMATION.get(), this.getX(), this.getY() + 1.0, this.getZ(), 1, dx, dy, dz, 0.2);
        }
    }

    protected void playHurtSound(@NotNull DamageSource pSource) {
        if (this.getPhase() == 2) {
            this.playSound(CompanionsSounds.MUTANT_TEDDY_HURT.get(), 0.55f, 1.0f);
        }
        super.playHurtSound(pSource);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return this.getPhase() == 2 ? CompanionsSounds.MUTANT_TEDDY_IDLE.get() : null;
    }

    public void move(@NotNull MoverType pType, @NotNull Vec3 pPos) {
        super.move(pType, pPos);
        this.checkInsideBlocks();
    }

    @Nullable
    public LivingEntity getOwner() {
        return super.getOwner();
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return this.getPhase() == 1 ? super.getDefaultDimensions(pose) : EntityDimensions.scalable((float)1.0f, (float)2.0f);
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.getSecondPhaseCounter() != 0 && this.getPhase() == 1) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (!this.isTame() && stack.getItem() == CompanionsItems.NEEDLE.get()) {
            if (this.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            this.tameInteraction(player);
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && player == this.getOwner() && stack.getItem() == CompanionsItems.ETERNAL_LIGHTER.get() && this.getPhase() == 1) {
            if (this.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            this.setSecondPhaseCounter(this.getSecondPhaseCounter() + 1);
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && player == this.getOwner() && stack.getItem() == Items.LAVA_BUCKET && this.getPhase() == 2) {
            if (this.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.position().x, this.position().y, this.position().z, new ItemStack((ItemLike)CompanionsItems.MUTANT_FLESH.get(), new Random().nextInt(1, 3))));
            this.playSound(SoundEvents.GENERIC_DRINK);
            return InteractionResult.SUCCESS;
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.getPhase() == 2) {
            if (this.deathTime >= 64 && !this.level().isClientSide() && !this.isRemoved()) {
                this.level().broadcastEntityEvent((Entity)this, (byte)60);
                this.remove(Entity.RemovalReason.KILLED);
            }
        } else if (this.deathTime >= 20 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        if (this.getPhase() == 1) {
            this.playSound(CompanionsSounds.TEDDY_STEP.get());
        } else {
            super.playStepSound(pPos, pState);
        }
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> pKey) {
        super.onSyncedDataUpdated(pKey);
        if (pKey.equals(PHASE)) {
            this.refreshDimensions();
        }
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("Phase")) {
            this.setPhase(pCompound.getInt("Phase"));
            if (this.getPhase() == 2) {
                this.moveControl = new TeddyMoveControl(this);
            }
        }
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Phase", this.getPhase());
        if (this.getSecondPhaseCounter() != 0) {
            pCompound.putInt("Phase", 2);
        }
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return this.getPhase() == 1 ? 3 : 2;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.TEDDY_KEEP_CHUNK_LOADED;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getPhase() == 1) {
            if (this.getSecondPhaseCounter() != 0 && this.getSecondPhaseCounter() <= 200) {
                event.getController().setAnimation(this.TRANSFORM);
            } else if (this.getMainAction() == 0) {
                RawAnimation vari = this.getSitVariation() == 0 ? this.LAY : (this.getSitVariation() == 1 ? this.SIT : this.SLEEP);
                event.getController().setAnimation(vari);
            } else if (this.getAttackType() == 1) {
                event.setAnimation(this.STAB);
            } else if (this.getAttackType() == 2) {
                event.setAnimation(this.AUTO_STAB);
            } else if (event.isMoving()) {
                event.getController().setAnimation(this.WALK);
            } else {
                event.getController().setAnimation(this.IDLE);
            }
        } else if (this.isDeadOrDying()) {
            event.getController().setAnimation(this.MUTATED_DEATH);
        } else if (this.getMainAction() == 0) {
            RawAnimation vari = this.getIsOnAir() ? this.MUTATED_SIT3 : (this.getSitVariation() == 0 ? this.MUTATED_SIT1 : this.MUTATED_SIT2);
            event.getController().setAnimation(vari);
        } else if (this.getAttackType() == 1) {
            event.getController().setAnimation(this.MUTATED_ATTACK1);
        } else if (this.getAttackType() == 2) {
            event.getController().setAnimation(this.MUTATED_ATTACK2);
        } else {
            event.getController().setAnimation(this.MUTATED_FLY);
        }
        return PlayState.CONTINUE;
    }
}

