/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.hostile;

import dev.xylonity.companions.common.entity.companion.PuppetGloveEntity;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.TickScheduler;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HostilePuppetGloveEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation BROOM_IDLE = RawAnimation.begin().thenPlay("broom_idle");
    private final RawAnimation BROOM_DROP = RawAnimation.begin().thenPlay("broom_drop");
    private final RawAnimation BROOM_PICKUP = RawAnimation.begin().thenPlay("broom_pickup");
    private final RawAnimation GAME_IDLE = RawAnimation.begin().thenPlay("game_idle");
    private final RawAnimation GAME_SCISSORS = RawAnimation.begin().thenPlay("game_scissors");
    private final RawAnimation GAME_ROCK = RawAnimation.begin().thenPlay("game_rock");
    private final RawAnimation GAME_PAPER = RawAnimation.begin().thenPlay("game_paper");
    private final RawAnimation GAME_ATTACK = RawAnimation.begin().thenPlay("game_attack");
    private final RawAnimation GAME_LOOSE = RawAnimation.begin().thenPlay("game_loose");
    private final RawAnimation GAME_TAME = RawAnimation.begin().thenPlay("game_tame");
    private static final EntityDataAccessor<Boolean> IS_PLAYING = SynchedEntityData.defineId(HostilePuppetGloveEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> GLOVE_MOVE = SynchedEntityData.defineId(HostilePuppetGloveEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BROOM_PHASE = SynchedEntityData.defineId(HostilePuppetGloveEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public UUID playingPlayerUUID = null;
    private long gameAutoStop = 0L;
    private long roundsLost = 0L;

    public HostilePuppetGloveEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return false;
    }

    public static AttributeSupplier setAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 160.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.55f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal(this, (Mob)this, Player.class, 15.0f, 0.01f){

            public boolean canUse() {
                Mob mob = this.mob;
                if (mob instanceof HostilePuppetGloveEntity) {
                    HostilePuppetGloveEntity glove = (HostilePuppetGloveEntity)mob;
                    return glove.playingPlayerUUID != null && super.canUse();
                }
                return super.canUse();
            }
        });
    }

    public void tick() {
        double lastX = this.getX();
        double lastZ = this.getZ();
        super.tick();
        if (!((long)this.tickCount <= this.gameAutoStop || this.isPlaying() && this.getGloveMove() != 0 || !this.isPlaying() && this.getBroomPhase() != 0 || this.playingPlayerUUID == null)) {
            this.setIsPlaying(false);
            this.setBroomPhase(2);
            TickScheduler.scheduleServer((Level)this.level(), () -> this.setBroomPhase(0), (int)20);
            this.playingPlayerUUID = null;
        }
        if (this.tickCount % 15 == 0 && !this.level().isClientSide && this.getBroomPhase() == 0 && !this.isPlaying()) {
            this.playSound(CompanionsSounds.HOSTILE_PUPPET_GLOVE_CLEAN.get(), 0.5f, 1.0f);
        }
        this.setPos(lastX, this.getY(), lastZ);
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (this.isPlaying() && this.getGloveMove() != 0 || !this.isPlaying() && this.getBroomPhase() != 0) {
            return InteractionResult.FAIL;
        }
        Vec3 entityEyePos = this.position().add(0.0, (double)this.getEyeHeight(), 0.0);
        Vec3 playerEyePos = pPlayer.position().add(0.0, (double)pPlayer.getEyeHeight(), 0.0);
        if (this.getLookAngle().dot(playerEyePos.subtract(entityEyePos).normalize()) < Math.cos(Math.toRadians(45.0))) {
            return InteractionResult.FAIL;
        }
        if (this.isPlaying()) {
            int res;
            if (!pPlayer.getUUID().equals(this.playingPlayerUUID)) {
                return InteractionResult.FAIL;
            }
            ItemStack stack = pPlayer.getItemInHand(pHand);
            if (!this.isValidItem(stack)) {
                pPlayer.displayClientMessage((Component)Component.translatable((String)"hostile_puppet_glove.companions.client_message.wrong_item"), true);
                return InteractionResult.FAIL;
            }
            if (this.level() instanceof ServerLevel) {
                this.setGloveMove(this.random.nextInt(1, 4));
            }
            if ((res = this.doesThePlayerWin(this.getPlayerMoveFromItem(stack), this.getGloveMove())) == 0) {
                TickScheduler.scheduleServer((Level)this.level(), () -> this.setGloveMove(0), (int)20);
                pPlayer.displayClientMessage((Component)Component.translatable((String)"hostile_puppet_glove.companions.client_message.draw"), true);
            } else if (res == 1) {
                TickScheduler.scheduleServer((Level)this.level(), () -> this.setGloveMove(4), (int)20);
                TickScheduler.scheduleServer((Level)this.level(), () -> this.playSound(CompanionsSounds.HOSTILE_PUPPET_GLOVE_ATTACK.get()), (int)20);
                List list = this.level().getEntitiesOfClass(Player.class, new AABB(this.blockPosition()).inflate(4.0));
                if (list.contains(pPlayer) && HostilePuppetGloveEntity.isEntityInFront((LivingEntity)this, (Entity)pPlayer, 120.0)) {
                    TickScheduler.scheduleServer((Level)this.level(), () -> this.doHurtTarget((Entity)pPlayer), (int)25);
                }
                TickScheduler.scheduleServer((Level)this.level(), () -> this.setGloveMove(0), (int)30);
                pPlayer.displayClientMessage((Component)Component.translatable((String)"hostile_puppet_glove.companions.client_message.glove_wins"), true);
            } else if (this.roundsLost != 3L) {
                TickScheduler.scheduleServer((Level)this.level(), () -> this.setGloveMove(5), (int)20);
                TickScheduler.scheduleServer((Level)this.level(), () -> this.playSound(CompanionsSounds.HOSTILE_PUPPET_GLOVE_LOOSE.get()), (int)20);
                TickScheduler.scheduleServer((Level)this.level(), () -> this.setGloveMove(0), (int)53);
                pPlayer.displayClientMessage((Component)Component.translatable((String)"hostile_puppet_glove.companions.client_message.player_wins_round"), true);
                ++this.roundsLost;
            } else {
                TickScheduler.scheduleServer((Level)this.level(), () -> this.setGloveMove(6), (int)20);
                TickScheduler.scheduleServer((Level)this.level(), () -> {
                    PuppetGloveEntity glove = (PuppetGloveEntity)CompanionsEntities.PUPPET_GLOVE.get().create(this.level());
                    if (glove != null) {
                        for (int i = 0; i < 50; ++i) {
                            double dx = (this.random.nextDouble() - 0.5) * 2.0;
                            double dy = (this.random.nextDouble() - 0.5) * 2.0;
                            double dz = (this.random.nextDouble() - 0.5) * 2.0;
                            Level patt0$temp = this.level();
                            if (!(patt0$temp instanceof ServerLevel)) continue;
                            ServerLevel level = (ServerLevel)patt0$temp;
                            level.sendParticles((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), 1, dx, dy, dz, 0.1);
                        }
                        glove.tame(pPlayer);
                        glove.moveTo(this.blockPosition().getCenter());
                        glove.setXRot(this.getXRot());
                        glove.setYRot(this.getYRot());
                        this.level().addFreshEntity((Entity)glove);
                    }
                    this.remove(Entity.RemovalReason.DISCARDED);
                }, (int)64);
                pPlayer.displayClientMessage((Component)Component.translatable((String)"hostile_puppet_glove.companions.client_message.player_wins"), true);
                this.playingPlayerUUID = null;
            }
            this.gameAutoStop = this.tickCount + 600;
        } else {
            this.setBroomPhase(1);
            TickScheduler.scheduleServer((Level)this.level(), () -> this.setIsPlaying(true), (int)20);
            TickScheduler.scheduleServer((Level)this.level(), () -> this.setGloveMove(0), (int)20);
            this.playingPlayerUUID = pPlayer.getUUID();
            this.gameAutoStop = this.tickCount + 600;
            pPlayer.displayClientMessage((Component)Component.translatable((String)"hostile_puppet_glove.companions.client_message.game_start"), true);
        }
        return InteractionResult.SUCCESS;
    }

    public static boolean isEntityInFront(LivingEntity viewer, Entity target, double fov) {
        Vec3 toTarget;
        Vec3 view = viewer.getLookAngle().normalize();
        double angle = Math.acos(view.dot(toTarget = new Vec3(target.getX(), viewer.getY(), target.getZ()).subtract(viewer.position()).normalize())) * 57.29577951308232;
        return angle < fov / 2.0;
    }

    private int doesThePlayerWin(int playerMove, int gloveMove) {
        if (playerMove == 0) {
            if (gloveMove == 1) {
                return 0;
            }
            if (gloveMove == 2) {
                return 1;
            }
            if (gloveMove == 3) {
                return 2;
            }
        } else if (playerMove == 1) {
            if (gloveMove == 1) {
                return 2;
            }
            if (gloveMove == 2) {
                return 0;
            }
            if (gloveMove == 3) {
                return 1;
            }
        } else if (playerMove == 2) {
            if (gloveMove == 1) {
                return 1;
            }
            if (gloveMove == 2) {
                return 2;
            }
            if (gloveMove == 3) {
                return 0;
            }
        }
        return -1;
    }

    private boolean isValidItem(ItemStack stack) {
        return stack.getItem() == Items.PAPER || stack.getItem() == Items.COBBLESTONE || stack.getItem() == Items.SHEARS;
    }

    private int getPlayerMoveFromItem(ItemStack stack) {
        if (stack.getItem() == Items.COBBLESTONE) {
            return 0;
        }
        if (stack.getItem() == Items.PAPER) {
            return 1;
        }
        if (stack.getItem() == Items.SHEARS) {
            return 2;
        }
        return -1;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_PLAYING, (Object)false);
        builder.define(GLOVE_MOVE, (Object)-1);
        builder.define(BROOM_PHASE, (Object)0);
    }

    private void setIsPlaying(boolean playing) {
        this.entityData.set(IS_PLAYING, (Object)playing);
    }

    private boolean isPlaying() {
        return (Boolean)this.entityData.get(IS_PLAYING);
    }

    private void setBroomPhase(int phase) {
        this.entityData.set(BROOM_PHASE, (Object)phase);
    }

    private int getBroomPhase() {
        return (Integer)this.entityData.get(BROOM_PHASE);
    }

    private void setGloveMove(int phase) {
        this.entityData.set(GLOVE_MOVE, (Object)phase);
    }

    private int getGloveMove() {
        return (Integer)this.entityData.get(GLOVE_MOVE);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.isPlaying()) {
            if (this.getGloveMove() == 1) {
                event.setAnimation(this.GAME_ROCK);
            } else if (this.getGloveMove() == 2) {
                event.setAnimation(this.GAME_PAPER);
            } else if (this.getGloveMove() == 3) {
                event.setAnimation(this.GAME_SCISSORS);
            } else if (this.getGloveMove() == 4) {
                event.setAnimation(this.GAME_ATTACK);
            } else if (this.getGloveMove() == 5) {
                event.setAnimation(this.GAME_LOOSE);
            } else if (this.getGloveMove() == 6) {
                event.setAnimation(this.GAME_TAME);
            } else {
                event.setAnimation(this.GAME_IDLE);
            }
        } else if (this.getBroomPhase() == 1) {
            event.setAnimation(this.BROOM_DROP);
        } else if (this.getBroomPhase() == 2) {
            event.setAnimation(this.BROOM_PICKUP);
        } else {
            event.setAnimation(this.BROOM_IDLE);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

