/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class FireGeiserProjectile
extends BaseProjectile
implements GeoEntity {
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");

    public FireGeiserProjectile(EntityType<? extends BaseProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void tick() {
        double px = this.getX();
        double py = this.getY();
        double pz = this.getZ();
        super.tick();
        this.setPos(px, py, pz);
        if (!this.level().isClientSide) {
            for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(2.5), e -> !Util.areEntitiesLinked((Entity)this, (Entity)e))) {
                entity.hurt(this.damageSources().indirectMagic((Entity)this, this.getOwner()), 7.5f);
                entity.setRemainingFireTicks(this.level().random.nextInt(1, 8) * 20);
            }
        }
    }

    @Override
    protected int baseLifetime() {
        return 20;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(this.IDLE);
        return PlayState.CONTINUE;
    }
}

