/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEffects;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class FireMarkRingProjectile
extends BaseProjectile {
    private final RawAnimation ACTIVATE = RawAnimation.begin().thenPlay("activate");
    private final double RADIUS = CompanionsConfig.FIRE_MARK_EFFECT_RADIUS;

    public FireMarkRingProjectile(EntityType<? extends BaseProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, new AABB(this.getX() - this.RADIUS, this.getY() - 1.0, this.getZ() - this.RADIUS, this.getX() + this.RADIUS, this.getY() + 1.0, this.getZ() + this.RADIUS), e -> !Util.areEntitiesLinked((Entity)this, (Entity)e))) {
                if (entity.hasEffect(CompanionsEffects.FIRE_MARK)) continue;
                entity.addEffect(new MobEffectInstance(CompanionsEffects.FIRE_MARK, this.level().random.nextInt(100, 400), 0, true, true));
                entity.playSound(CompanionsSounds.SPELL_HIT_MARK.get());
            }
        }
        if (this.tickCount >= this.getLifetime()) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", this::predicate));
    }

    @Override
    protected int baseLifetime() {
        return 30;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(this.ACTIVATE);
        return PlayState.CONTINUE;
    }
}

