/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animation.AnimatableManager;

public class FloorCakeCreamProjectile
extends BaseProjectile
implements GeoEntity {
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.defineId(FloorCakeCreamProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<String> ARMOR_NAME = SynchedEntityData.defineId(FloorCakeCreamProjectile.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public FloorCakeCreamProjectile(EntityType<? extends BaseProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        if (!this.level().isClientSide) {
            this.entityData.set(SIZE, (Object)Float.valueOf(new Random().nextFloat(1.0f, 2.0f)));
            this.setLifetime(new Random().nextInt(80, 180));
        }
    }

    @Override
    public void tick() {
        super.tick();
        AABB effectArea = new AABB(this.getX() - (double)this.getSize(), this.getY() - 0.5, this.getZ() - (double)this.getSize(), this.getX() + (double)this.getSize(), this.getY() + 0.5, this.getZ() + (double)this.getSize());
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, effectArea);
        for (LivingEntity entity : entities) {
            if (this.getOwner() != null && !Util.areEntitiesLinked((Entity)entity, (Entity)this)) {
                Vec3 v = entity.getDeltaMovement();
                entity.setDeltaMovement(v.x * 0.2, v.y, v.z * 0.2);
                entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 40, 0));
                continue;
            }
            switch (this.getArmorName()) {
                case "chocolate": {
                    entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 80, 0));
                    break;
                }
                case "strawberry": {
                    entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 80, 0));
                    break;
                }
                case "vanilla": {
                    entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 80, 0));
                    break;
                }
            }
        }
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("ArmorName")) {
            this.setArmorName(pCompound.getString("ArmorName"));
        }
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putString("ArmorName", this.getArmorName());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SIZE, (Object)Float.valueOf(1.2f));
        builder.define(ARMOR_NAME, (Object)"default");
    }

    public float getSize() {
        return ((Float)this.entityData.get(SIZE)).floatValue();
    }

    public void setArmorName(String name) {
        this.entityData.set(ARMOR_NAME, (Object)name);
    }

    public String getArmorName() {
        return (String)this.entityData.get(ARMOR_NAME);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    @Override
    protected int baseLifetime() {
        return 200;
    }
}

