/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class MagicRayPieceProjectile
extends BaseProjectile {
    private static final RawAnimation APPEAR = RawAnimation.begin().thenPlay("appear");
    private static final RawAnimation DISAPPEAR = RawAnimation.begin().thenPlay("disappear");
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private static final EntityDataAccessor<Float> YAW = SynchedEntityData.defineId(MagicRayPieceProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> PITCH = SynchedEntityData.defineId(MagicRayPieceProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public MagicRayPieceProjectile(EntityType<? extends BaseProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.noPhysics = false;
    }

    protected boolean canHitEntity(@NotNull Entity entity) {
        if (Util.areEntitiesLinked((Entity)this, entity)) {
            return false;
        }
        return super.canHitEntity(entity);
    }

    @Override
    public void tick() {
        List hitEntities;
        super.tick();
        if (!this.level().isClientSide && !(hitEntities = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.75), this::canHitEntity)).isEmpty()) {
            LivingEntity hit = (LivingEntity)hitEntities.get(0);
            hit.hurt(this.damageSources().magic(), (float)CompanionsConfig.MAGIC_PIECE_DAMAGE);
        }
    }

    public float getYaw() {
        return ((Float)this.entityData.get(YAW)).floatValue();
    }

    public void setYaw(float yaw) {
        this.entityData.set(YAW, (Object)Float.valueOf(yaw));
    }

    public float getPitch() {
        return ((Float)this.entityData.get(PITCH)).floatValue();
    }

    public void setPitch(float pitch) {
        this.entityData.set(PITCH, (Object)Float.valueOf(pitch));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(YAW, (Object)Float.valueOf(0.0f));
        builder.define(PITCH, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", this::predicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "extraController", this::extraPredicate));
    }

    @Override
    protected int baseLifetime() {
        return 18;
    }

    private <T extends GeoAnimatable> PlayState extraPredicate(AnimationState<T> event) {
        if (this.tickCount >= this.getLifetime() - 6) {
            event.getController().setAnimation(DISAPPEAR);
        } else if (this.tickCount <= 4) {
            event.getController().setAnimation(APPEAR);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(IDLE);
        return PlayState.CONTINUE;
    }
}

