/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item;

import dev.xylonity.companions.common.block.RespawnTotemBlock;
import dev.xylonity.companions.common.blockentity.RespawnTotemBlockEntity;
import dev.xylonity.companions.common.item.TooltipItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class HourglassItem
extends TooltipItem {
    public HourglassItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected String tooltipName() {
        return "";
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.companions.hourglass_1").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.companions.hourglass_2").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.companions.hourglass_shift"));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Player player = ctx.getPlayer();
        Block block = state.getBlock();
        if (!(block instanceof RespawnTotemBlock)) {
            return InteractionResult.PASS;
        }
        RespawnTotemBlock respawnTotemBlock = (RespawnTotemBlock)block;
        BlockEntity blockEntity = respawnTotemBlock.getMultiblockBlockEntity(level, pos, state);
        if (!(blockEntity instanceof RespawnTotemBlockEntity)) {
            return InteractionResult.PASS;
        }
        RespawnTotemBlockEntity totem = (RespawnTotemBlockEntity)blockEntity;
        if (!level.isClientSide && player != null) {
            if (ctx.getItemInHand().getMaxDamage() - ctx.getItemInHand().getDamageValue() < 12) {
                player.displayClientMessage((Component)Component.translatable((String)"hourglass.companions.client_message.required_durability"), true);
                return InteractionResult.PASS;
            }
            if (totem.getCaptureCooldown() > 0) {
                return InteractionResult.SUCCESS;
            }
            totem.setCapturing(true);
            respawnTotemBlock.updateLitState(level, pos, state, true);
            level.scheduleTick(pos, (Block)respawnTotemBlock, 60);
            ctx.getItemInHand().hurtAndBreak(12, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)ctx.getHand()));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

