/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item;

import dev.xylonity.companions.common.blockentity.AbstractShadeAltarBlockEntity;
import dev.xylonity.companions.common.entity.ShadeEntity;
import dev.xylonity.companions.common.event.CompanionsEntityTracker;
import dev.xylonity.companions.common.item.TooltipItem;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ShadowBellItem
extends TooltipItem {
    private static final String ST_DIM = "stored_dim";
    private static final String ST_X = "stored_x";
    private static final String ST_Y = "stored_y";
    private static final String ST_Z = "stored_z";
    private static final String BELL_CURR = "bell_curr";
    private static final String BELL_MAX = "bell_max";
    private static final String UUID_SHADE = "cached_shade";
    private static final String ALTAR_NAME = "altar_name";

    public ShadowBellItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isBarVisible(ItemStack stack) {
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag t = customData.copyTag();
        return t != null && t.contains(BELL_CURR) && t.contains(BELL_MAX);
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag t = customData.copyTag();
        int curr = t != null ? t.getInt(BELL_CURR) : 0;
        int max = t != null ? t.getInt(BELL_MAX) : 1;
        return Math.round((float)curr * 13.0f / (float)max);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return 0xAA0077;
    }

    public void inventoryTick(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull Entity pEntity, int pSlotId, boolean pIsSelected) {
        String currName;
        BlockEntity blockEntity;
        ServerLevel maybe;
        if (!(pEntity instanceof Player)) {
            return;
        }
        if (pLevel.isClientSide) {
            return;
        }
        CustomData customData = (CustomData)pStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        if (tag == null || !tag.contains(ST_DIM)) {
            return;
        }
        ServerLevel altarLevel = null;
        if (pLevel.getServer() != null && (maybe = pLevel.getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)tag.getString(ST_DIM))))) instanceof ServerLevel) {
            altarLevel = maybe;
        }
        BlockPos pos = new BlockPos(tag.getInt(ST_X), tag.getInt(ST_Y), tag.getInt(ST_Z));
        if (altarLevel == null || !((blockEntity = altarLevel.getBlockEntity(pos)) instanceof AbstractShadeAltarBlockEntity)) {
            this.clearLink(pStack);
            return;
        }
        AbstractShadeAltarBlockEntity altar = (AbstractShadeAltarBlockEntity)blockEntity;
        if (altar.getCharges() <= 0) {
            return;
        }
        if (tag.getInt(BELL_CURR) != altar.getCharges() || tag.getInt(BELL_MAX) != altar.getMaxCharges()) {
            tag.putInt(BELL_CURR, altar.getCharges());
            tag.putInt(BELL_MAX, altar.getMaxCharges());
            pStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        if (!(currName = altarLevel.getBlockState(pos).getBlock().getName().getString()).equals(tag.getString(ALTAR_NAME))) {
            tag.putString(ALTAR_NAME, currName);
            pStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag t = customData.copyTag();
        if (!(t != null && t.contains(ST_DIM) && t.contains(ST_X) && t.contains(ST_Y) && t.contains(ST_Z))) {
            tooltip.add((Component)Component.translatable((String)"tooltip.item.companions.shadow_bell.default").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
            return;
        }
        if (t.contains(BELL_CURR) && t.contains(ALTAR_NAME)) {
            tooltip.add((Component)Component.translatable((String)"tooltip.item.companions.shadow_bell.linked_to", (Object[])new Object[]{t.getString(ALTAR_NAME)}));
            tooltip.add((Component)Component.translatable((String)"tooltip.item.companions.shadow_bell.charges_remaining", (Object[])new Object[]{t.getInt(BELL_CURR)}));
            if (t.hasUUID(UUID_SHADE)) {
                Entity e = CompanionsEntityTracker.getEntityByUUID(t.getUUID(UUID_SHADE));
                if (e instanceof ShadeEntity) {
                    ShadeEntity shade = (ShadeEntity)e;
                    tooltip.add((Component)Component.translatable((String)"tooltip.item.companions.shadow_bell.lifetime", (Object[])new Object[]{shade.getLifetime() / 20}));
                } else {
                    t.remove(UUID_SHADE);
                    stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)t));
                }
            }
        }
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }

    @Override
    protected String tooltipName() {
        return "";
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        ItemStack stack = ctx.getItemInHand();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AbstractShadeAltarBlockEntity)) {
            if (ctx.getPlayer() != null) {
                return this.use(level, ctx.getPlayer(), ctx.getHand()).getResult();
            }
            return InteractionResult.PASS;
        }
        AbstractShadeAltarBlockEntity altar = (AbstractShadeAltarBlockEntity)blockEntity;
        if (altar.getCharges() <= 0 && ctx.getPlayer() != null) {
            ctx.getPlayer().displayClientMessage((Component)Component.translatable((String)"shadow_bell.companions.client_message.altar_empty"), true);
        }
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        tag.putString(ST_DIM, level.dimension().location().toString());
        tag.putInt(ST_X, pos.getX());
        tag.putInt(ST_Y, pos.getY());
        tag.putInt(ST_Z, pos.getZ());
        tag.putInt(BELL_CURR, altar.getCharges());
        tag.putInt(BELL_MAX, altar.getMaxCharges());
        tag.putString(ALTAR_NAME, level.getBlockState(pos).getBlock().getName().getString());
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        if (ctx.getPlayer() != null) {
            ctx.getPlayer().displayClientMessage((Component)Component.translatable((String)"shadow_bell.companions.client_message.altar_saved"), true);
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack pStack, @NotNull Player pPlayer, @NotNull LivingEntity pInteractionTarget, @NotNull InteractionHand pUsedHand) {
        ShadeEntity shade;
        CustomData customData = (CustomData)pStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        if (tag != null && pInteractionTarget instanceof ShadeEntity && (shade = (ShadeEntity)pInteractionTarget).getOwnerUUID() != null && shade.getOwnerUUID().equals(pPlayer.getUUID())) {
            pInteractionTarget.discard();
            if (tag.hasUUID(UUID_SHADE) && pInteractionTarget.getUUID().equals(tag.getUUID(UUID_SHADE)) && pInteractionTarget instanceof ShadeEntity) {
                tag.remove(UUID_SHADE);
                pStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            }
            return InteractionResult.SUCCESS;
        }
        return super.interactLivingEntity(pStack, pPlayer, pInteractionTarget, pUsedHand);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.getItemInHand(pUsedHand);
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        if (pLevel.isClientSide) {
            return InteractionResultHolder.success((Object)stack);
        }
        if (!(tag != null && tag.contains(ST_DIM) && tag.contains(ST_X) && tag.contains(ST_Y) && tag.contains(ST_Z) && pLevel.getServer() != null)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        ServerLevel world = pLevel.getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)tag.getString(ST_DIM))));
        if (world == null) {
            pPlayer.displayClientMessage((Component)Component.translatable((String)"shadow_bell.companions.client_message.couldnt_find"), true);
            this.clearLink(stack);
            return InteractionResultHolder.pass((Object)stack);
        }
        BlockEntity blockEntity = world.getBlockEntity(new BlockPos(tag.getInt(ST_X), tag.getInt(ST_Y), tag.getInt(ST_Z)));
        if (blockEntity instanceof AbstractShadeAltarBlockEntity) {
            ShadeEntity entity;
            AbstractShadeAltarBlockEntity altar = (AbstractShadeAltarBlockEntity)blockEntity;
            if (altar.getCharges() <= 0) {
                pPlayer.displayClientMessage((Component)Component.translatable((String)"shadow_bell.companions.client_message.no_charges"), true);
                return InteractionResultHolder.pass((Object)stack);
            }
            UUID oldShadeUUID = altar.activeShadeUUID;
            if (oldShadeUUID != null) {
                Entity oldShade = world.getEntity(oldShadeUUID);
                if (oldShade instanceof ShadeEntity) {
                    oldShade.discard();
                }
                altar.activeShadeUUID = null;
            }
            if ((entity = altar.spawnShade(pPlayer.level(), pPlayer, pUsedHand, this)) != null) {
                tag.putUUID(UUID_SHADE, entity.getUUID());
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            }
            if (altar.consumeCharge()) {
                altar.sync();
                tag.putInt(BELL_CURR, altar.getCharges());
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            } else {
                pPlayer.displayClientMessage((Component)Component.translatable((String)"shadow_bell.companions.client_message.no_charges"), true);
                this.clearLink(stack);
            }
            pPlayer.level().playSound(null, pPlayer.blockPosition(), CompanionsSounds.SHADE_BELL_SUMMON.get(), pPlayer.getSoundSource(), 0.3f, 1.0f);
        } else {
            this.clearLink(stack);
            pPlayer.displayClientMessage((Component)Component.translatable((String)"shadow_bell.companions.client_message.couldnt_find"), true);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)false);
    }

    private void clearLink(ItemStack stack) {
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        if (tag == null) {
            return;
        }
        tag.remove(ST_DIM);
        tag.remove(ST_X);
        tag.remove(ST_Y);
        tag.remove(ST_Z);
        tag.remove(BELL_CURR);
        tag.remove(BELL_MAX);
        tag.remove(UUID_SHADE);
        tag.remove(ALTAR_NAME);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }
}

