/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item.book.books;

import dev.xylonity.companions.common.entity.projectile.StoneSpikeProjectile;
import dev.xylonity.companions.common.item.book.AbstractMagicBook;
import dev.xylonity.companions.common.material.ArmorMaterials;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.knightlib.api.TickScheduler;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class StoneSpikesBook
extends AbstractMagicBook {
    public StoneSpikesBook(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected String tooltipName() {
        return "stone_spikes_book";
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        double yaw = Math.toRadians(player.yRotO);
        Vec3 baseDir = new Vec3(-Math.sin(yaw), 0.0, Math.cos(yaw)).normalize();
        int spikes = 10;
        this.spawnSpikeRow(baseDir, spikes, player);
        this.spawnSpikeRow(Util.rotateHorizontalDirection(baseDir, -30.0), (int)((double)spikes * 0.3), player);
        this.spawnSpikeRow(Util.rotateHorizontalDirection(baseDir, 30.0), (int)((double)spikes * 0.3), player);
        if (!level.isClientSide) {
            player.getCooldowns().addCooldown((Item)this, (int)((double)CompanionsConfig.STONE_SPIKES_COOLDOWN * (1.0 - (double)Util.hasFullSetOn(player, ArmorMaterials.MAGE) * CompanionsConfig.MAGE_SET_COOLDOWN_REDUCTION)));
        }
        return super.use(level, player, usedHand);
    }

    @Override
    protected void playSound(Player player) {
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENCHANTMENT_TABLE_USE, player.getSoundSource(), 1.0f, 1.0f);
    }

    private void spawnSpikeRow(Vec3 direction, int count, Player player) {
        for (int i = 0; i < count; ++i) {
            Vec3 line = player.position().add(direction.scale(1.5 + (double)i * 1.5));
            int ix = Mth.floor((double)line.x);
            int iz = Mth.floor((double)line.z);
            int iy = Mth.floor((double)line.y);
            StoneSpikeProjectile spike = (StoneSpikeProjectile)CompanionsEntities.STONE_SPIKE_PROJECTILE.get().create(player.level());
            if (spike == null) continue;
            spike.moveTo((double)ix + 0.5, this.findSpikeH(player.level(), ix, iy, iz, Math.toRadians(player.getXRot()) < 0.0) + 1, (double)iz + 0.5, player.getYRot(), 0.0f);
            spike.setOwner((Entity)player);
            if (i == 0) {
                player.level().addFreshEntity((Entity)spike);
                continue;
            }
            TickScheduler.scheduleBoth((Level)player.level(), () -> player.level().addFreshEntity((Entity)spike), (int)(i * 2));
        }
    }

    private int findSpikeH(Level level, int x, int yStart, int z, boolean shouldCheckUp) {
        BiPredicate<Level, BlockPos> solid = (level1, pos) -> !level1.getBlockState(pos).getCollisionShape((BlockGetter)level1, pos).isEmpty();
        if (shouldCheckUp) {
            BlockPos pos2;
            int y;
            for (y = yStart; y <= level.getMaxBuildHeight(); ++y) {
                pos2 = new BlockPos(x, y, z);
                if (!solid.test(level, pos2)) continue;
                return y;
            }
            for (y = yStart; y >= level.getMinBuildHeight(); --y) {
                pos2 = new BlockPos(x, y, z);
                if (!solid.test(level, pos2)) continue;
                return y;
            }
        } else {
            BlockPos pos3;
            int y;
            for (y = yStart; y >= level.getMinBuildHeight(); --y) {
                pos3 = new BlockPos(x, y, z);
                if (!solid.test(level, pos3)) continue;
                return y;
            }
            for (y = yStart; y <= level.getMaxBuildHeight(); ++y) {
                pos3 = new BlockPos(x, y, z);
                if (!solid.test(level, pos3)) continue;
                return y;
            }
        }
        return yStart;
    }
}

