/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item.weapon;

import dev.xylonity.companions.common.entity.projectile.BloodTornadoProjectile;
import dev.xylonity.companions.common.item.generic.GenericGeckoAxeItem;
import dev.xylonity.companions.common.material.ItemMaterials;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BloodAxeItem
extends GenericGeckoAxeItem {
    public BloodAxeItem(Item.Properties properties, String resourceKey, ItemMaterials material) {
        super(properties, resourceKey, material);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!pLevel.isClientSide) {
            for (int i = 0; i < 4; ++i) {
                double angleRad = Math.toRadians(player.getYRot() + (float)(i * 90));
                BloodTornadoProjectile tornado = (BloodTornadoProjectile)CompanionsEntities.BLOOD_TORNADO_PROJECTILE.get().create(pLevel);
                if (tornado == null) continue;
                tornado.setPos(player.getX(), player.getY() + (double)(player.getBbHeight() * 0.4f), player.getZ());
                tornado.setOwner((Entity)player);
                tornado.setAlpha((float)angleRad);
                tornado.shoot(-Math.sin(angleRad), 0.0, Math.cos(angleRad), 1.2525f, 0.0f);
                pLevel.addFreshEntity((Entity)tornado);
            }
            pLevel.playSound(null, player.blockPosition(), CompanionsSounds.SPELL_RELEASE_DARK_HOLE.get(), SoundSource.PLAYERS);
            player.getCooldowns().addCooldown((Item)this, CompanionsConfig.CRYSTALLIZED_BLOOD_AXE_COOLDOWN);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)pLevel.isClientSide());
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag flag) {
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.icon.companions.star").append((Component)Component.translatable((String)"tooltip.item.companions.key.blood_weapon").withStyle(ChatFormatting.YELLOW)));
        pTooltipComponents.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"tooltip.item.companions.key.abilities").withStyle(ChatFormatting.DARK_GRAY)));
        pTooltipComponents.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)"tooltip.item.companions.crystallized_blood_axe").withStyle(ChatFormatting.WHITE)));
        pTooltipComponents.add((Component)Component.literal((String)"   ").append((Component)Component.translatable((String)"tooltip.item.companions.crystallized_blood_axe_desc_1").withStyle(ChatFormatting.GRAY)));
        pTooltipComponents.add((Component)Component.literal((String)"   ").append((Component)Component.translatable((String)"tooltip.item.companions.crystallized_blood_axe_desc_2").withStyle(ChatFormatting.GRAY)));
        pTooltipComponents.add((Component)Component.literal((String)"   ").append((Component)Component.translatable((String)"tooltip.item.companions.crystallized_blood_axe_desc_3").withStyle(ChatFormatting.GRAY)));
        super.appendHoverText(stack, context, pTooltipComponents, flag);
    }
}

