/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item.weapon;

import dev.xylonity.companions.common.entity.projectile.BloodSlashProjectile;
import dev.xylonity.companions.common.entity.projectile.HolinessStartProjectile;
import dev.xylonity.companions.common.item.generic.GenericGeckoSwordItem;
import dev.xylonity.companions.common.material.ItemMaterials;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BloodSwordItem
extends GenericGeckoSwordItem {
    public BloodSwordItem(Item.Properties properties, String resourceKey, ItemMaterials itemMaterial) {
        super(properties, resourceKey, itemMaterial);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!pLevel.isClientSide) {
            BloodSlashProjectile slash = (BloodSlashProjectile)CompanionsEntities.BLOOD_SLASH_PROJECTILE.get().create(pLevel);
            if (slash != null) {
                Vec3 spawnPos = player.position().add(0.0, (double)player.getEyeHeight(), 0.0);
                slash.setOwner((Entity)player);
                slash.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
                slash.setDeltaMovement(player.getLookAngle().scale((double)HolinessStartProjectile.SPEED));
                slash.setNoGravity(true);
                pLevel.addFreshEntity((Entity)slash);
            }
            pLevel.playSound(null, player.blockPosition(), CompanionsSounds.SPELL_RELEASE_DARK_HOLE.get(), SoundSource.PLAYERS);
            player.getCooldowns().addCooldown((Item)this, CompanionsConfig.CRYSTALLIZED_BLOOD_SWORD_COOLDOWN);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)pLevel.isClientSide());
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag flag) {
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.icon.companions.star").append((Component)Component.translatable((String)"tooltip.item.companions.key.blood_weapon").withStyle(ChatFormatting.YELLOW)));
        pTooltipComponents.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"tooltip.item.companions.key.abilities").withStyle(ChatFormatting.DARK_GRAY)));
        pTooltipComponents.add((Component)Component.literal((String)"  ").append((Component)Component.translatable((String)"tooltip.item.companions.crystallized_blood_sword").withStyle(ChatFormatting.WHITE)));
        pTooltipComponents.add((Component)Component.literal((String)"   ").append((Component)Component.translatable((String)"tooltip.item.companions.crystallized_blood_sword_desc_1").withStyle(ChatFormatting.GRAY)));
        pTooltipComponents.add((Component)Component.literal((String)"   ").append((Component)Component.translatable((String)"tooltip.item.companions.crystallized_blood_sword_desc_2").withStyle(ChatFormatting.GRAY)));
        pTooltipComponents.add((Component)Component.literal((String)"   ").append((Component)Component.translatable((String)"tooltip.item.companions.crystallized_blood_sword_desc_3").withStyle(ChatFormatting.GRAY)));
        super.appendHoverText(stack, context, pTooltipComponents, flag);
    }
}

