/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.particle;

import dev.xylonity.knightlib.common.particle.AbstractRibbonTrailParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public class ShadeAltarRibbonParticle
extends AbstractRibbonTrailParticle {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/particle/trail2.png");
    private static final Vec3 DARK_RED = new Vec3((double)0.2901961f, 0.0, 0.0);
    private final float RED_;
    private final float GREEN_;
    private final float BLUE_;

    public ShadeAltarRibbonParticle(ClientLevel level, Vec3 targetId, float r, float g, float b, double radius) {
        super(level, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, r, g, b);
        this.RED_ = r;
        this.GREEN_ = g;
        this.BLUE_ = b;
        this.lifetime = 30;
        this.gravity = 0.0f;
        Vec3 spawnPos = targetId.add(ShadeAltarRibbonParticle.randomOffsetAbove(level.random, radius));
        this.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        Vec3 dir = targetId.subtract(spawnPos);
        Vec3 vel = dir.normalize().scale(dir.length() / (double)(this.lifetime - 2));
        this.xd = vel.x;
        this.yd = vel.y;
        this.zd = vel.z;
        this.savePosInBuffer();
    }

    private static Vec3 randomOffsetAbove(RandomSource rand, double radius) {
        double theta1 = 2.0 * rand.nextDouble() - 1.0;
        double theta2 = Math.sqrt(1.0 - theta1 * theta1);
        double phi = Math.PI * 2 * rand.nextDouble();
        double r = Math.cbrt(rand.nextDouble()) * radius;
        double x = theta2 * Math.cos(phi) * r;
        double y = Math.abs(theta1 * r);
        double z = theta2 * Math.sin(phi) * r;
        return new Vec3(x, y, z);
    }

    public void tick() {
        super.tick();
        float lifeFrac = (float)this.age / (float)this.lifetime;
        float fadeIn = Math.min(lifeFrac * 2.0f, 1.0f);
        float fadeOut = 1.0f - lifeFrac;
        this.ribbonAlpha = fadeIn * fadeOut;
        float t = 1.0f - fadeOut;
        this.r = this.RED_ * (1.0f - t) + (float)ShadeAltarRibbonParticle.DARK_RED.x * t;
        this.g = this.GREEN_ * (1.0f - t) + (float)ShadeAltarRibbonParticle.DARK_RED.y * t;
        this.b = this.BLUE_ * (1.0f - t) + (float)ShadeAltarRibbonParticle.DARK_RED.z * t;
    }

    protected float getRibbonHeight() {
        return 0.2f;
    }

    protected ResourceLocation getRibbonSprite() {
        return TEXTURE;
    }

    protected int totalSegments() {
        return 6;
    }
}

