/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.recipe;

import com.mojang.serialization.MapCodec;
import dev.xylonity.companions.registry.CompanionsBlocks;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public final class EmptyPuppetRecipe
implements Recipe<RecipeInput> {
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"empty_puppet_interaction");
    public static final RecipeSerializer<EmptyPuppetRecipe> SERIALIZER = new Serializer();
    public static final RecipeType<EmptyPuppetRecipe> RECIPE_TYPE = new Type();
    public final ItemStack input = new ItemStack((ItemLike)CompanionsBlocks.EMPTY_PUPPET.get());

    public boolean matches(RecipeInput inv, @NotNull Level lvl) {
        return ItemStack.isSameItem((ItemStack)inv.getItem(0), (ItemStack)this.input);
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput inv, @NotNull HolderLookup.Provider reg) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int w, int h) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider reg) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @NotNull
    public RecipeType<?> getType() {
        return RECIPE_TYPE;
    }

    public static final class Serializer
    implements RecipeSerializer<EmptyPuppetRecipe> {
        private static final MapCodec<EmptyPuppetRecipe> CODEC = MapCodec.unit((Object)new EmptyPuppetRecipe());
        private static final StreamCodec<RegistryFriendlyByteBuf, EmptyPuppetRecipe> STREAM_CODEC = StreamCodec.unit((Object)new EmptyPuppetRecipe());

        @NotNull
        public MapCodec<EmptyPuppetRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, EmptyPuppetRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static final class Type
    implements RecipeType<EmptyPuppetRecipe> {
        public String toString() {
            return ID.toString();
        }
    }
}

