/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.recipe;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record SoulFurnaceItemRecipe(ItemStack input, ItemStack output) implements Recipe<RecipeInput>
{
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"soul_furnace_item_interaction");
    public static final RecipeSerializer<SoulFurnaceItemRecipe> SERIALIZER = new Serializer();
    public static final RecipeType<SoulFurnaceItemRecipe> RECIPE_TYPE = new Type();

    public boolean matches(RecipeInput inv, @NotNull Level lvl) {
        return ItemStack.isSameItem((ItemStack)inv.getItem(0), (ItemStack)this.input);
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput inv, @NotNull HolderLookup.Provider reg) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int w, int h) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider reg) {
        return this.output.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @NotNull
    public RecipeType<?> getType() {
        return RECIPE_TYPE;
    }

    public static final class Serializer
    implements RecipeSerializer<SoulFurnaceItemRecipe> {
        private static final MapCodec<SoulFurnaceItemRecipe> CODEC = MapCodec.unit((Object)new SoulFurnaceItemRecipe(ItemStack.EMPTY, ItemStack.EMPTY));
        private static final StreamCodec<RegistryFriendlyByteBuf, SoulFurnaceItemRecipe> STREAM_CODEC = StreamCodec.unit((Object)new SoulFurnaceItemRecipe(ItemStack.EMPTY, ItemStack.EMPTY));

        @NotNull
        public MapCodec<SoulFurnaceItemRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, SoulFurnaceItemRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static final class Type
    implements RecipeType<SoulFurnaceItemRecipe> {
        public String toString() {
            return ID.toString();
        }
    }
}

