/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.compat.jei;

import dev.xylonity.companions.common.recipe.CroissantDragonArmorRecipe;
import dev.xylonity.companions.common.recipe.CroissantEggRecipe;
import dev.xylonity.companions.common.recipe.EmptyPuppetRecipe;
import dev.xylonity.companions.common.recipe.HourglassRecipe;
import dev.xylonity.companions.common.recipe.ShadeAltarRecipe;
import dev.xylonity.companions.common.recipe.ShadeMawAltarRecipe;
import dev.xylonity.companions.common.recipe.ShadeSwordAltarRecipe;
import dev.xylonity.companions.common.recipe.SoulFurnaceEntityRecipe;
import dev.xylonity.companions.common.recipe.SoulFurnaceItemRecipe;
import dev.xylonity.companions.common.recipe.SoulFurnaceRecipe;
import dev.xylonity.companions.compat.jei.category.AntlionRecipeCategory;
import dev.xylonity.companions.compat.jei.category.CroissantDragonArmorRecipeCategory;
import dev.xylonity.companions.compat.jei.category.CroissantEggRecipeCategory;
import dev.xylonity.companions.compat.jei.category.PuppetRecipeCategory;
import dev.xylonity.companions.compat.jei.category.RespawnTotemRecipeCategory;
import dev.xylonity.companions.compat.jei.category.ShadeAltarRecipeCategory;
import dev.xylonity.companions.compat.jei.category.ShadeMawAltarRecipeCategory;
import dev.xylonity.companions.compat.jei.category.ShadeSwordAltarRecipeCategory;
import dev.xylonity.companions.compat.jei.category.SoulFurnaceEntityRecipeCategory;
import dev.xylonity.companions.compat.jei.category.SoulFurnaceItemRecipeCategory;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsRecipes;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public final class CompanionsPlugin
implements IModPlugin {
    private static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"jei_plugin");

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        reg.addRecipeCategories(new IRecipeCategory[]{new ShadeMawAltarRecipeCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new ShadeSwordAltarRecipeCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new ShadeAltarRecipeCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new CroissantEggRecipeCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new CroissantDragonArmorRecipeCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new RespawnTotemRecipeCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new AntlionRecipeCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new PuppetRecipeCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new SoulFurnaceItemRecipeCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new SoulFurnaceEntityRecipeCategory(reg.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        reg.addRecipes(ShadeMawAltarRecipeCategory.TYPE, List.of(new ShadeMawAltarRecipe()));
        reg.addRecipes(ShadeSwordAltarRecipeCategory.TYPE, List.of(new ShadeSwordAltarRecipe()));
        reg.addRecipes(CroissantEggRecipeCategory.TYPE, List.of(new CroissantEggRecipe()));
        reg.addRecipes(ShadeAltarRecipeCategory.TYPE, List.of(new ShadeAltarRecipe()));
        reg.addRecipes(RespawnTotemRecipeCategory.TYPE, List.of(new HourglassRecipe()));
        reg.addRecipes(AntlionRecipeCategory.TYPE, List.of(new HourglassRecipe()));
        reg.addRecipes(PuppetRecipeCategory.TYPE, List.of(new EmptyPuppetRecipe()));
        ClientLevel lvl = Minecraft.getInstance().level;
        if (lvl != null) {
            ArrayList<SoulFurnaceItemRecipe> itemRecipes = new ArrayList<SoulFurnaceItemRecipe>();
            ArrayList<SoulFurnaceEntityRecipe> entityRecipes = new ArrayList<SoulFurnaceEntityRecipe>();
            for (RecipeHolder base : lvl.getRecipeManager().getAllRecipesFor(CompanionsRecipes.SOUL_FURNACE_TYPE.get())) {
                SoulFurnaceRecipe r;
                ItemStack[] inputs;
                Recipe recipe = base.value();
                if (!(recipe instanceof SoulFurnaceRecipe) || (inputs = (r = (SoulFurnaceRecipe)recipe).input().getItems()).length == 0) continue;
                ItemStack in = inputs[0];
                if (r.resultItem() != null) {
                    itemRecipes.add(new SoulFurnaceItemRecipe(in, new ItemStack((ItemLike)r.resultItem(), Math.max(1, r.resultCount()))));
                    continue;
                }
                if (r.resultBlock() != null) {
                    itemRecipes.add(new SoulFurnaceItemRecipe(in, new ItemStack((ItemLike)r.resultBlock())));
                    continue;
                }
                if (r.resultEntity() == null) continue;
                entityRecipes.add(new SoulFurnaceEntityRecipe(in, r.resultEntity()));
            }
            reg.addRecipes(SoulFurnaceItemRecipeCategory.TYPE, itemRecipes);
            reg.addRecipes(SoulFurnaceEntityRecipeCategory.TYPE, entityRecipes);
        }
        reg.addRecipes(CroissantDragonArmorRecipeCategory.TYPE, List.of(new CroissantDragonArmorRecipe(new ItemStack((ItemLike)CompanionsItems.CROISSANT_DRAGON_ARMOR_VANILLA.get())), new CroissantDragonArmorRecipe(new ItemStack((ItemLike)CompanionsItems.CROISSANT_DRAGON_ARMOR_CHOCOLATE.get())), new CroissantDragonArmorRecipe(new ItemStack((ItemLike)CompanionsItems.CROISSANT_DRAGON_ARMOR_STRAWBERRY.get()))));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst(new ItemStack((ItemLike)CompanionsBlocks.SHADE_MAW_ALTAR.get()), new RecipeType[]{ShadeMawAltarRecipeCategory.TYPE});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)CompanionsBlocks.SHADE_SWORD_ALTAR.get()), new RecipeType[]{ShadeSwordAltarRecipeCategory.TYPE});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)CompanionsBlocks.CROISSANT_EGG.get()), new RecipeType[]{CroissantEggRecipeCategory.TYPE});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)CompanionsBlocks.RESPAWN_TOTEM.get()), new RecipeType[]{RespawnTotemRecipeCategory.TYPE});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)CompanionsBlocks.EMPTY_PUPPET.get()), new RecipeType[]{PuppetRecipeCategory.TYPE});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)CompanionsBlocks.SOUL_FURNACE.get()), new RecipeType[]{SoulFurnaceItemRecipeCategory.TYPE});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)CompanionsBlocks.SOUL_FURNACE.get()), new RecipeType[]{SoulFurnaceEntityRecipeCategory.TYPE});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)CompanionsItems.CRYSTALLIZED_BLOOD.get()), new RecipeType[]{ShadeAltarRecipeCategory.TYPE});
    }
}

