/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.compat.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xylonity.companions.common.entity.companion.AntlionEntity;
import dev.xylonity.companions.common.recipe.HourglassRecipe;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class AntlionRecipeCategory
implements IRecipeCategory<HourglassRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"antlion_interaction");
    public static final RecipeType<HourglassRecipe> TYPE = new RecipeType(UID, HourglassRecipe.class);
    public static final ResourceLocation SHADOW = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/gui/sprites.png");
    private AntlionEntity cachedEntity;
    private final IDrawable icon;
    private int phaseCooldown;

    public AntlionRecipeCategory(IGuiHelper gui) {
        this.icon = gui.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CompanionsItems.HOURGLASS.get()));
    }

    @NotNull
    public RecipeType<HourglassRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"jei.companions.antlion_interaction.title");
    }

    public int getWidth() {
        return 120;
    }

    public int getHeight() {
        return 80;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, HourglassRecipe rec, @NotNull IFocusGroup focuses) {
        this.cachedEntity = null;
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 5).addItemStack(rec.input);
    }

    private AntlionEntity getOrCreateEntity() {
        if (this.cachedEntity == null) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null) {
                this.cachedEntity = new AntlionEntity(CompanionsEntities.ANTLION.get(), (Level)mc.level);
                this.cachedEntity.setNoGravity(true);
                this.phaseCooldown = 600;
            }
        }
        return this.cachedEntity;
    }

    private void updateAnimation() {
        if (this.cachedEntity != null) {
            this.cachedEntity.tickCount = (int)(System.currentTimeMillis() / 50L);
            if (this.phaseCooldown <= 0) {
                this.cachedEntity.cycleVariant();
                this.phaseCooldown = 600;
            }
        }
        if (this.phaseCooldown > 0) {
            --this.phaseCooldown;
        }
    }

    public void draw(@NotNull HourglassRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SHADOW);
        guiGraphics.blit(SHADOW, 40, 60, 216, 5, 38, 16);
        guiGraphics.blit(SHADOW, 33, 10, 46, 3, 33, 22);
        guiGraphics.blit(SHADOW, 9, 4, 120, 0, 19, 19);
        this.updateAnimation();
        AntlionEntity entity = this.getOrCreateEntity();
        GeoEntityRenderer entityRenderer = entity != null ? (GeoEntityRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)entity) : null;
        PoseStack pose = guiGraphics.pose();
        MultiBufferSource.BufferSource buffer = guiGraphics.bufferSource();
        if (entity != null) {
            pose.pushPose();
            pose.translate(60.0, 68.0, 27.5);
            pose.scale(24.0f, 24.0f, 24.0f);
            pose.mulPose(Axis.XP.rotationDegrees(-25.0f));
            pose.mulPose(Axis.YP.rotationDegrees(45.0f));
            pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
            entityRenderer.render((Entity)entity, 0.0f, Minecraft.getInstance().getTimer().getGameTimeDeltaTicks(), pose, (MultiBufferSource)buffer, LightTexture.pack((int)15, (int)15));
            pose.popPose();
        }
        buffer.endBatch();
    }
}

