/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.compat.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xylonity.companions.common.blockentity.RespawnTotemBlockEntity;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.entity.projectile.RespawnTotemRingProjectile;
import dev.xylonity.companions.common.recipe.HourglassRecipe;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsEntities;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class RespawnTotemRecipeCategory
implements IRecipeCategory<HourglassRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"respawn_totem_interaction");
    public static final RecipeType<HourglassRecipe> TYPE = new RecipeType(UID, HourglassRecipe.class);
    public static final ResourceLocation SHADOW = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/gui/sprites.png");
    private RespawnTotemBlockEntity cachedBlockEntity;
    private RespawnTotemRingProjectile cachedEntity;
    private long lastUpdateTime = 0L;
    private final IDrawable icon;
    private long lastEntityAppearTime = 0L;

    public RespawnTotemRecipeCategory(IGuiHelper gui) {
        this.icon = gui.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CompanionsBlocks.RESPAWN_TOTEM.get()));
    }

    @NotNull
    public RecipeType<HourglassRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"jei.companions.respawn_totem_interaction.title");
    }

    public int getWidth() {
        return 120;
    }

    public int getHeight() {
        return 100;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, HourglassRecipe rec, @NotNull IFocusGroup focuses) {
        this.cachedEntity = null;
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 5).addItemStack(rec.input);
    }

    private RespawnTotemBlockEntity getOrCreateBlockEntity() {
        if (this.cachedBlockEntity == null) {
            this.cachedBlockEntity = new RespawnTotemBlockEntity(BlockPos.ZERO, CompanionsBlocks.RESPAWN_TOTEM.get().defaultBlockState());
            this.cachedBlockEntity.setCharges(1);
        }
        return this.cachedBlockEntity;
    }

    private RespawnTotemRingProjectile getOrCreateEntity() {
        if (this.cachedEntity == null) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null) {
                this.cachedEntity = new RespawnTotemRingProjectile((EntityType<? extends BaseProjectile>)CompanionsEntities.RESPAWN_TOTEM_RING_PROJECTILE.get(), (Level)mc.level);
                this.cachedEntity.setNoGravity(true);
            }
        }
        return this.cachedEntity;
    }

    private void updateAnimation() {
        long currentTime = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
        }
        if (currentTime - this.lastEntityAppearTime >= 3900L) {
            this.lastEntityAppearTime = currentTime;
            RespawnTotemRingProjectile entity = this.getOrCreateEntity();
            if (entity != null) {
                entity.tickCount = 0;
            }
        }
        this.lastUpdateTime = currentTime;
        if (this.cachedEntity != null) {
            this.cachedEntity.tickCount = (int)(System.currentTimeMillis() / 50L);
        }
    }

    public void draw(@NotNull HourglassRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        GeoEntityRenderer entityRenderer;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SHADOW);
        guiGraphics.blit(SHADOW, 21, 69, 170, 0, 42, 25);
        guiGraphics.blit(SHADOW, 33, 10, 46, 3, 33, 22);
        guiGraphics.blit(SHADOW, 9, 4, 120, 0, 19, 19);
        this.updateAnimation();
        RespawnTotemBlockEntity blockEntity = this.getOrCreateBlockEntity();
        RespawnTotemRingProjectile entity = this.getOrCreateEntity();
        GeoBlockRenderer blockRenderer = (GeoBlockRenderer)Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer((BlockEntity)blockEntity);
        GeoEntityRenderer geoEntityRenderer = entityRenderer = entity != null ? (GeoEntityRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)entity) : null;
        if (blockRenderer == null) {
            return;
        }
        PoseStack pose = guiGraphics.pose();
        MultiBufferSource.BufferSource buffer = guiGraphics.bufferSource();
        pose.pushPose();
        pose.translate(44.0f, 80.0f, 120.0f);
        pose.scale(24.0f, 24.0f, 24.0f);
        pose.mulPose(Axis.XP.rotationDegrees(-25.0f));
        pose.mulPose(Axis.YP.rotationDegrees(145.0f));
        pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
        Matrix3f normalMat = pose.last().normal();
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f front = new Vector3f(0.0f, 0.0f, -1.0f);
        normalMat.transform(up).normalize();
        normalMat.transform(front).normalize();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)up, (Vector3f)front);
        try {
            float partialTicks = (float)((double)(System.currentTimeMillis() - this.lastUpdateTime) / 50.0);
            blockRenderer.render((BlockEntity)blockEntity, partialTicks, pose, (MultiBufferSource)buffer, LightTexture.pack((int)15, (int)15), OverlayTexture.NO_OVERLAY);
        }
        catch (Exception e) {
            blockRenderer.render((BlockEntity)blockEntity, Minecraft.getInstance().getTimer().getGameTimeDeltaTicks(), pose, (MultiBufferSource)buffer, LightTexture.pack((int)15, (int)15), OverlayTexture.NO_OVERLAY);
        }
        pose.popPose();
        if (entity != null) {
            pose.pushPose();
            pose.translate(60.0f, 80.0f, 100.0f);
            pose.scale(5.0f, 5.0f, 5.0f);
            pose.mulPose(Axis.XP.rotationDegrees(-25.0f));
            pose.mulPose(Axis.YP.rotationDegrees(45.0f));
            pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
            entityRenderer.render((Entity)entity, 0.0f, Minecraft.getInstance().getTimer().getGameTimeDeltaTicks(), pose, (MultiBufferSource)buffer, LightTexture.pack((int)15, (int)15));
            pose.popPose();
        }
        buffer.endBatch();
    }
}

