/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.projectile.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xylonity.companions.client.projectile.model.FireMarkModel;
import dev.xylonity.companions.common.entity.projectile.FireMarkProjectile;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class FireMarkRenderer
extends GeoEntityRenderer<FireMarkProjectile> {
    private static final float MAX_PITCH_ANGLE = 5.0f;

    public FireMarkRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new FireMarkModel());
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull FireMarkProjectile animatable) {
        return new ResourceLocation("companions", "textures/entity/fire_mark.png");
    }

    public RenderType getRenderType(FireMarkProjectile animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110473_((ResourceLocation)this.getTextureLocation(animatable));
    }

    protected void applyRotations(FireMarkProjectile entity, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        if (camera != null) {
            float maxPitch;
            float pitchFactor;
            double horizontalDist;
            double dx = camera.m_90583_().f_82479_ - entity.m_20185_();
            double dz = camera.m_90583_().f_82481_ - entity.m_20189_();
            if (Math.abs(dx) < 1.0E-4 && Math.abs(dz) < 1.0E-4) {
                dx = 0.0;
                dz = 1.0;
            }
            float desiredYaw = (float)Math.toDegrees(Math.atan2(dx, dz));
            float yawCorrection = 0.0f;
            desiredYaw += yawCorrection;
            double dy = camera.m_90583_().f_82480_ - entity.m_20186_();
            float rawPitch = (float)Math.toDegrees(Math.atan2(dy, horizontalDist = Math.sqrt(dx * dx + dz * dz)));
            float desiredPitch = rawPitch * (pitchFactor = 0.5f);
            if (desiredPitch > (maxPitch = 5.0f)) {
                desiredPitch = maxPitch;
            }
            if (desiredPitch < -maxPitch) {
                desiredPitch = -maxPitch;
            }
            poseStack.m_252781_(Axis.f_252436_.m_252977_(desiredYaw));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(desiredPitch));
        }
        super.applyRotations((Entity)entity, poseStack, ageInTicks, rotationYaw, partialTicks);
    }
}

