/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.blockentity.AbstractTeslaBlockEntity;
import dev.xylonity.companions.common.tesla.TeslaConnectionManager;
import dev.xylonity.companions.common.tesla.behaviour.platform.RecallPlatformPulseBehaviour;
import dev.xylonity.companions.common.util.interfaces.ITeslaNodeBehaviour;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RecallPlatformBlockEntity
extends AbstractTeslaBlockEntity {
    private static final int COOLDOWN_TICKS = 20;
    private final Set<BlockPos> partnerPositions = new HashSet<BlockPos>();
    private int cooldown = 0;
    private final ITeslaNodeBehaviour pulseBehaviour = new RecallPlatformPulseBehaviour();

    public RecallPlatformBlockEntity(BlockPos pos, BlockState st) {
        super((BlockEntityType)CompanionsBlockEntities.RECALL_PLATFORM.get(), pos, st);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (!(t instanceof RecallPlatformBlockEntity)) {
            return;
        }
        RecallPlatformBlockEntity platform = (RecallPlatformBlockEntity)t;
        platform.cooldown = level.m_45976_(Player.class, new AABB(platform.m_58899_()).m_82386_(0.0, 1.0, 0.0).m_82400_(0.5)).isEmpty() ? 20 : --platform.cooldown;
        platform.pulseBehaviour.process(platform, level, blockPos, blockState);
        ++platform.tickCount;
        platform.sync();
    }

    public void onStepped(ServerPlayer player) {
        if (this.cooldown > 0) {
            return;
        }
        if (this.m_58904_() == null) {
            return;
        }
        ArrayList<BlockPos> shuffled = new ArrayList<BlockPos>(this.partnerPositions);
        Collections.shuffle(shuffled, new Random());
        for (BlockPos target : shuffled) {
            BlockEntity blockEntity = this.m_58904_().m_7702_(target);
            if (!(blockEntity instanceof RecallPlatformBlockEntity)) {
                this.partnerPositions.remove(target);
                this.m_6596_();
                continue;
            }
            RecallPlatformBlockEntity otherPlatform = (RecallPlatformBlockEntity)blockEntity;
            TeslaConnectionManager manager = TeslaConnectionManager.getInstance();
            if (!manager.getConnectedComponent(this.asConnectionNode()).contains(otherPlatform.asConnectionNode())) {
                this.partnerPositions.remove(target);
                this.m_6596_();
                continue;
            }
            if (this.f_58857_ != null) {
                this.f_58857_.m_5594_(null, this.m_58899_(), CompanionsSounds.TEDDY_TRANSFORMATION.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            player.m_6021_((double)target.m_123341_() + 0.5, (double)(target.m_123342_() + 1), (double)target.m_123343_() + 0.5);
            if (this.f_58857_ != null) {
                this.f_58857_.m_5594_(null, target, CompanionsSounds.TEDDY_TRANSFORMATION.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.cooldown = 20;
            otherPlatform.cooldown = 20;
            return;
        }
    }

    public void updatePartners(Set<BlockPos> newPartners) {
        this.partnerPositions.clear();
        this.partnerPositions.addAll(newPartners);
        this.m_6596_();
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        ListTag list = new ListTag();
        for (BlockPos p : this.partnerPositions) {
            CompoundTag t = new CompoundTag();
            t.m_128405_("X", p.m_123341_());
            t.m_128405_("Y", p.m_123342_());
            t.m_128405_("Z", p.m_123343_());
            list.add((Object)t);
        }
        tag.m_128365_("Partners", (Tag)list);
        tag.m_128405_("Cooldown", this.cooldown);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.partnerPositions.clear();
        if (tag.m_128425_("Partners", 9)) {
            ListTag list = tag.m_128437_("Partners", 10);
            for (Tag t : list) {
                CompoundTag c = (CompoundTag)t;
                this.partnerPositions.add(new BlockPos(c.m_128451_("X"), c.m_128451_("Y"), c.m_128451_("Z")));
            }
        }
        this.cooldown = tag.m_128451_("Cooldown");
    }

    @Override
    @NotNull
    public Vec3 electricalChargeOriginOffset() {
        return Vec3.f_82478_;
    }

    @Override
    @NotNull
    public Vec3 electricalChargeEndOffset() {
        return new Vec3(0.0, 0.5, 0.0);
    }
}

