/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.generic;

import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.config.CompanionsConfig;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class CompanionFollowOwnerGoal
extends Goal {
    public static final int TELEPORT_WHEN_DISTANCE_IS = CompanionsConfig.COMPANIONS_FOLLOW_OWNER_TELEPORT_DISTANCE;
    protected final CompanionEntity tamable;
    protected LivingEntity owner;
    protected final LevelReader level;
    protected final double speedModifier;
    protected final PathNavigation navigation;
    protected int timeToRecalcPath;
    protected final float stopDistance;
    protected final float startDistance;
    protected float oldWaterCost;
    protected final boolean canFly;

    public CompanionFollowOwnerGoal(CompanionEntity pTamable, double pSpeedModifier, float pStartDistance, float pStopDistance, boolean pCanFly) {
        this.tamable = pTamable;
        this.level = pTamable.m_9236_();
        this.speedModifier = pSpeedModifier;
        this.navigation = pTamable.m_21573_();
        this.startDistance = pStartDistance;
        this.stopDistance = pStopDistance;
        this.canFly = pCanFly;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity owner = this.tamable.m_269323_();
        if (this.tamable.getMainAction() != 1) {
            return false;
        }
        if (owner == null) {
            return false;
        }
        if (owner.m_5833_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.tamable.m_20280_((Entity)owner) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        return !(this.tamable.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    protected boolean unableToMove() {
        return this.tamable.m_21827_() || this.tamable.m_20159_() || this.tamable.m_21523_();
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tamable.m_21439_(BlockPathTypes.WATER);
        this.tamable.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.tamable.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.tamable.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.tamable.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (this.tamable.m_20280_((Entity)this.owner) >= (double)(TELEPORT_WHEN_DISTANCE_IS * TELEPORT_WHEN_DISTANCE_IS)) {
                this.teleportToOwner();
            } else {
                this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
            }
        }
    }

    protected void teleportToOwner() {
        BlockPos pos = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int x = this.randomIntInclusive(-3, 3);
            int y = this.randomIntInclusive(-1, 1);
            int z = this.randomIntInclusive(-3, 3);
            if (!this.maybeTeleportTo(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int pX, int pY, int pZ) {
        if (Math.abs((double)pX - this.owner.m_20185_()) < 2.0 && Math.abs((double)pZ - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(pX, pY, pZ))) {
            return false;
        }
        this.tamable.m_7678_((float)pX + 0.5f, pY, (float)pZ + 0.5f, this.tamable.m_146908_(), this.tamable.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos pPos) {
        if (WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pPos.m_122032_()) != BlockPathTypes.WALKABLE) {
            return false;
        }
        if (!this.canFly && this.level.m_8055_(pPos.m_7495_()).m_60734_() instanceof LeavesBlock) {
            return false;
        }
        return this.level.m_45756_((Entity)this.tamable, this.tamable.m_20191_().m_82338_(pPos.m_121996_((Vec3i)this.tamable.m_20183_())));
    }

    private int randomIntInclusive(int pMin, int pMax) {
        return this.tamable.m_217043_().m_188503_(pMax - pMin + 1) + pMin;
    }
}

