/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionRandomStrollGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.entity.ai.puppet.glove.goal.PuppetGloveAttackGoal;
import dev.xylonity.companions.common.entity.companion.PuppetEntity;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class PuppetGloveEntity
extends CompanionEntity {
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation ATTACK = RawAnimation.begin().thenPlay("attack");
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation RECEIVE_PUPPET = RawAnimation.begin().thenPlay("recieve_puppet");
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.m_135353_(PuppetGloveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TRANSFORMING = SynchedEntityData.m_135353_(PuppetGloveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int TRANSFORMATION_TICKS = 25;
    private int transformationCounter = -1;

    public PuppetGloveEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.transformationCounter != -1) {
                ++this.transformationCounter;
            }
            if (this.transformationCounter == 25) {
                this.tameGlove(this.m_269323_());
            }
        }
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 1;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.PUPPET_GLOVE_KEEP_CHUNK_LOADED;
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.m_216990_(CompanionsSounds.PUPPET_GLOVE_STEP.get());
    }

    public static AttributeSupplier setAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, CompanionsConfig.PUPPET_GLOVE_MAX_LIFE).m_22268_(Attributes.f_22281_, CompanionsConfig.PUPPET_GLOVE_DAMAGE).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PuppetGloveAttackGoal(this, 10, 40));
        this.f_21345_.m_25352_(3, (Goal)new CompanionFollowOwnerGoal(this, 0.6, 6.0f, 2.0f, false));
        this.f_21345_.m_25352_(3, (Goal)new CompanionRandomStrollGoal(this, 0.43));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.isTransforming()) {
            return InteractionResult.PASS;
        }
        Item item = player.m_21120_(hand).m_41720_();
        if (item == CompanionsBlocks.EMPTY_PUPPET.get().m_5456_() && this.m_21824_() && this.m_269323_() != null && this.m_269323_() == player) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            this.m_21816_(player.m_20148_());
            this.setTransforming(true);
            ++this.transformationCounter;
            return InteractionResult.SUCCESS;
        }
        if (this.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private void tameGlove(LivingEntity player) {
        PuppetEntity puppet = (PuppetEntity)((EntityType)CompanionsEntities.PUPPET.get()).m_20615_(this.m_9236_());
        if (puppet != null) {
            puppet.m_20219_(this.m_20182_());
            if (player instanceof Player) {
                Player p = (Player)player;
                puppet.tameInteraction(p);
            } else if (this.m_269323_() == null && this.m_21805_() != null) {
                puppet.m_21816_(this.m_21805_());
            }
            this.m_9236_().m_7967_((Entity)puppet);
        }
        this.generatePoofParticles();
        this.m_146870_();
    }

    private void generatePoofParticles() {
        for (int i = 0; i < 30; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20182_().f_82479_, this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20182_().f_82481_, 1, dx, dy, dz, 0.1);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(TRANSFORMING, (Object)false);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(IS_ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(IS_ATTACKING, (Object)attacking);
    }

    public boolean isTransforming() {
        return (Boolean)this.f_19804_.m_135370_(TRANSFORMING);
    }

    public void setTransforming(boolean transforming) {
        this.f_19804_.m_135381_(TRANSFORMING, (Object)transforming);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.isTransforming()) {
            event.getController().setAnimation(this.RECEIVE_PUPPET);
        } else if (this.isAttacking()) {
            event.getController().setAnimation(this.ATTACK);
        } else if (this.getMainAction() == 0) {
            event.getController().setAnimation(this.SIT);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

